/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobHistoryEvent;
import br.pucrio.tecgraf.soma.job.JobInitEvent;
import br.pucrio.tecgraf.soma.job.JobProgressEvent;
import br.pucrio.tecgraf.soma.job.JobRescheduledEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.JobStageInEvent;
import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import br.pucrio.tecgraf.soma.job.JobSystemFailureEvent;
import br.pucrio.tecgraf.soma.job.application.service.KafkaOffsetInfoService;
import br.pucrio.tecgraf.soma.job.application.service.job.JobService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobHistoryEventService {
    private final Logger logger = LoggerFactory.getLogger(JobHistoryEventService.class);
    private JobService jobService;
    private KafkaOffsetInfoService kafkaOffsetInfoService;

    @Autowired
    public JobHistoryEventService(JobService jobService, KafkaOffsetInfoService kafkaOffsetInfoService) {
        this.jobService = jobService;
        this.kafkaOffsetInfoService = kafkaOffsetInfoService;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void process(JobHistoryEvent historyEvent, int partitionId, long lastOffset) throws IOException {
        switch (historyEvent.getEventName()) {
            case "JobScheduledEvent": {
                this.jobService.scheduleJob((JobScheduledEvent)historyEvent.getEvent());
                break;
            }
            case "JobRescheduledEvent": {
                this.jobService.rescheduleJob((JobRescheduledEvent)historyEvent.getEvent());
                break;
            }
            case "JobInitEvent": {
                this.jobService.initJob((JobInitEvent)historyEvent.getEvent());
                break;
            }
            case "JobSystemFailureEvent": {
                this.jobService.systemFailureJob((JobSystemFailureEvent)historyEvent.getEvent());
                break;
            }
            case "JobStageInEvent": {
                this.jobService.stageJobIn((JobStageInEvent)historyEvent.getEvent());
                break;
            }
            case "JobStageOutEvent": {
                this.jobService.stageJobOut((JobStageOutEvent)historyEvent.getEvent());
                break;
            }
            case "JobExecutingEvent": {
                this.jobService.executeJob((JobExecutingEvent)historyEvent.getEvent());
                break;
            }
            case "JobFinishedEvent": {
                this.jobService.finishJob((JobFinishedEvent)historyEvent.getEvent());
                break;
            }
            case "JobProgressEvent": {
                this.jobService.progressUpdate((JobProgressEvent)historyEvent.getEvent());
                break;
            }
            default: {
                this.logger.warn("An unsupported event of type {} was received and discarded.", (Object)historyEvent.getEventName());
                return;
            }
        }
        if (!historyEvent.getEventName().equals("JobProgressEvent")) {
            this.kafkaOffsetInfoService.updateOffsetInfo(partitionId, lastOffset);
        }
    }
}

