package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.ExitStatusConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToDoubleConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToIntegerConverter;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class FinishedJobMapper {
  private static final String TYPE_MAP_NAME = "JobFinishedEventToJob";
  private static FinishedJobMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<JobFinishedEvent, Job> typeMap;

  private FinishedJobMapper() {
    modelMapper = new ModelMapper();

    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap = modelMapper.createTypeMap(JobFinishedEvent.class, Job.class, TYPE_MAP_NAME);
    typeMap.addMappings(mapper -> mapper.skip(Job::setId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGroupId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setProjectId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setAutomaticallyMachineSelection));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSelectedMachines));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcesses));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcessesByMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSubmissionTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDescription));
    typeMap.addMappings(mapper -> mapper.skip(Job::setMultipleExecution));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExecutionMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobOwner));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobType));
    typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
    typeMap.addMappings(mapper -> mapper.skip(Job::setPriority));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));
    typeMap.addMappings(mapper -> mapper.skip(Job::setProgress));

    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobFinishedEvent::getTimestamp, Job::setLastModifiedTime));

    typeMap.addMappings(
        mapper ->
            mapper
                .using(new ExitStatusConverter())
                .map(JobFinishedEvent::getExitStatus, Job::setExitStatus));
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToIntegerConverter())
                .map(JobFinishedEvent::getWallclockTime, Job::setWallclockTime));
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToDoubleConverter())
                .map(JobFinishedEvent::getCpuTime, Job::setCpuTime));
    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobFinishedEvent::getEndTime, Job::setEndTime));

    modelMapper.validate();
  }

  public static FinishedJobMapper getInstance() {
    if (instance == null) {
      instance = new FinishedJobMapper();
    }
    return instance;
  }

  public void map(JobFinishedEvent event, Job job) {
    modelMapper.map(event, job, TYPE_MAP_NAME);
  }
}
