package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

import br.pucrio.tecgraf.soma.job.JobInitEvent;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.converter.LongToLocalDateTimeConverter;

public class InitJobMapper {
  private static final String TYPE_MAP_NAME = "JobInitEventToJob";
  private static InitJobMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<JobInitEvent, Job> typeMap;

  private InitJobMapper() {
    modelMapper = new ModelMapper();

    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap = modelMapper.createTypeMap(JobInitEvent.class, Job.class, TYPE_MAP_NAME);

    typeMap.addMappings(mapper -> mapper.skip(Job::setJobId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGroupId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setProjectId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setAutomaticallyMachineSelection));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSelectedMachines));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcesses));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfProcessesByMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setSubmissionTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDescription));
    typeMap.addMappings(mapper -> mapper.skip(Job::setMultipleExecution));
    typeMap.addMappings(mapper -> mapper.skip(Job::setNumberOfRetries));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitCode));
    typeMap.addMappings(mapper -> mapper.skip(Job::setGuiltyNodeId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExitStatus));
    typeMap.addMappings(mapper -> mapper.skip(Job::setWallclockTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setCpuTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setEndTime));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobOwner));
    typeMap.addMappings(mapper -> mapper.skip(Job::setId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setJobType));
    typeMap.addMappings(mapper -> mapper.skip(Job::setRamMemory));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowId));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowVersion));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowName));
    typeMap.addMappings(mapper -> mapper.skip(Job::setFlowRaw));
    typeMap.addMappings(mapper -> mapper.skip(Job::setPriority));
    typeMap.addMappings(mapper -> mapper.skip(Job::setExecutionMachine));
    typeMap.addMappings(mapper -> mapper.skip(Job::setDeleted));
    typeMap.addMappings(mapper -> mapper.skip(Job::setProgress));
    typeMap.addMappings(mapper -> mapper.skip(Job::setReplicaJob));

    typeMap.addMappings(
        mapper ->
            mapper
                .using(new LongToLocalDateTimeConverter())
                .map(JobInitEvent::getTimestamp, Job::setLastModifiedTime));

    modelMapper.validate();
  }

  public static InitJobMapper getInstance() {
    if (instance == null) {
      instance = new InitJobMapper();
    }
    return instance;
  }

  public void map(JobInitEvent event, Job job) {
    modelMapper.map(event, job, TYPE_MAP_NAME);
  }
}
