package br.pucrio.tecgraf.soma.job.infrastructure.persistence;

import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.LostEventRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.KafkaOffsetInfoRepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.unitofwork.impl.ScopedJPAUnitOfWork;

import jakarta.persistence.EntityManagerFactory;

public class ConsumerUnitOfWork extends ScopedJPAUnitOfWork{

	private JobRepository jobRepository;
	private KafkaOffsetInfoRepository kafkaOffsetInfoRepository;
	private LostEventRepository lostEventRepository;

	public ConsumerUnitOfWork(EntityManagerFactory factory) {
		super(factory);
	}

	public JobRepository commandRepository() {
		if(jobRepository == null) {
			jobRepository = new JobRepository();
		}
		return jobRepository;
	}

	public KafkaOffsetInfoRepository kafkaOffsetInfoRepository() {
		if(kafkaOffsetInfoRepository == null) {
			kafkaOffsetInfoRepository = new KafkaOffsetInfoRepository();
		}
		return kafkaOffsetInfoRepository;
	}
	
	public LostEventRepository lostEventRepository() {
		if(kafkaOffsetInfoRepository == null) {
			lostEventRepository = new LostEventRepository();
		}
		return lostEventRepository;
	}
}
