/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.menu;

import br.pucrio.tecgraf.soma.job.menu.OptionType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineMenu {
    private Options options;
    private Map<String, Boolean> unique;
    private Map<String, String> mandatory;
    private Map<String, String> optional;
    private Map<String, String> mapDefault;
    private boolean parsed;

    private void startValues() {
        this.unique = new HashMap();
        this.mandatory = new HashMap();
        this.optional = new HashMap();
        this.mapDefault = new HashMap();
        this.parsed = false;
    }

    public CommandLineMenu(Options options) {
        this.options = options;
        this.startValues();
    }

    public CommandLineMenu() {
        this.options = new Options();
        this.startValues();
    }

    public Options getOptions() {
        return this.options;
    }

    private void addType(OptionType type, String name, String value) {
        if (OptionType.UNIQUE.equals((Object)type)) {
            this.unique.put(name, false);
        } else if (OptionType.MANDATORY.equals((Object)type)) {
            this.mandatory.put(name, value);
        } else if (OptionType.OPTIONAL.equals((Object)type)) {
            this.optional.put(name, value);
        } else if (OptionType.DEFAULT.equals((Object)type)) {
            this.mapDefault.put(name, value);
        }
    }

    public Option.Builder createOptionBuilder(String shortName, String longName, String description) {
        Option.Builder opBuilder = shortName == null || shortName.equals("") ? Option.builder() : Option.builder((String)shortName);
        opBuilder = opBuilder.longOpt(longName).desc(description);
        return opBuilder;
    }

    private void addOption(String shortName, String longName, String description, String argName) {
        Option.Builder opBuilder = this.createOptionBuilder(shortName, longName, description);
        opBuilder = this.addArg(opBuilder, argName);
        this.options.addOption(opBuilder.build());
    }

    public void addOption(String shortName, String longName, String description, String argName, OptionType type) {
        this.addOption(shortName, longName, description, argName);
        this.addType(type, longName, null);
    }

    public void addOption(String shortName, String longName, String description, String argName, OptionType type, String value) {
        if (type.equals((Object)OptionType.DEFAULT)) {
            this.addOption(shortName, longName, description, argName);
            this.addType(type, longName, value);
        }
    }

    public void addOption(String builder, String longName, String description, OptionType type) {
        this.options.addOption(this.createOptionBuilder(builder, longName, description).build());
        this.addType(type, longName, null);
    }

    private Option.Builder addArg(Option.Builder opBuilder, String argName) {
        return opBuilder.hasArg().argName(argName);
    }

    private void addValue(CommandLine line, Map<String, String> map) {
        for (String key : map.keySet()) {
            if (!line.hasOption(key)) continue;
            map.put(key, line.getOptionValue(key));
        }
    }

    private int calcSizeWithoutNullValue(Map<String, String> map) {
        int count = 0;
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            ++count;
        }
        return count;
    }

    public void parser(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(this.options, args);
        this.addValueUnique(line, this.unique);
        this.addValue(line, this.mandatory);
        this.addValue(line, this.optional);
        this.addValue(line, this.mapDefault);
        this.parsed = true;
    }

    private void addValueUnique(CommandLine line, Map<String, Boolean> unique) {
        for (String key : unique.keySet()) {
            if (!line.hasOption(key)) continue;
            unique.put(key, true);
        }
    }

    public boolean hasUnique() {
        for (String key : this.unique.keySet()) {
            if (((Boolean)this.unique.get(key)).booleanValue()) continue;
            this.unique.remove(key);
        }
        return this.parsed && this.unique.size() == 1;
    }

    private void checkParseState() throws Exception {
        if (!this.parsed) {
            throw new Exception("Call parser before get unique element");
        }
    }

    public String getUnique() throws Exception {
        this.checkParseState();
        if (this.unique.size() > 1) {
            Object exceptionMsg = "You can not use ";
            int size = this.unique.size();
            int i = 1;
            for (String key : this.unique.keySet()) {
                exceptionMsg = size < i ? (String)exceptionMsg + this.unique.get(key) + ", " : (String)exceptionMsg + this.unique.get(key);
                ++i;
            }
            exceptionMsg = (String)exceptionMsg + " at the same time";
            throw new Exception((String)exceptionMsg);
        }
        if (this.unique.size() == 0) {
            throw new Exception("There is not unique option");
        }
        Iterator iterator = this.unique.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            return key;
        }
        return null;
    }

    public boolean hasAllMandatory() {
        return this.parsed && this.calcSizeWithoutNullValue(this.mandatory) == this.mandatory.size();
    }

    public Map<String, String> getMandatory() throws Exception {
        this.checkParseState();
        if (this.hasAllMandatory()) {
            return this.mandatory;
        }
        Object expectionMsg = "";
        int erroCount = 0;
        for (String key : this.mandatory.keySet()) {
            if (this.mandatory.get(key) != null) continue;
            if (++erroCount > 1) {
                expectionMsg = (String)expectionMsg + ", ";
            }
            expectionMsg = (String)expectionMsg + key;
        }
        if (erroCount == 1) {
            expectionMsg = (String)expectionMsg + " is mandatory\n";
        } else if (erroCount > 1) {
            expectionMsg = "They are mandatory: " + (String)expectionMsg + "\n";
        }
        throw new Exception((String)expectionMsg);
    }

    public boolean hasOptionalAndDefault() {
        try {
            return this.parsed && this.getOptionalAndDefault().size() >= 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, String> getOptionalAndDefault() throws Exception {
        this.checkParseState();
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.optional.keySet()) {
            String value = (String)this.optional.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        for (String key : this.mapDefault.keySet()) {
            result.put(key, (String)this.mapDefault.get(key));
        }
        return result;
    }
}

