package br.pucrio.tecgraf.soma.job.menu;

import java.util.Map;

import org.apache.commons.cli.HelpFormatter;

public class Menu {

  private static final String KAFKA_SERVER_ADDRESS = "server";
  private static final String KAFKA_SCHEMA_REGISTRY_URL = "schema-registry";
  private static final String KAFKA_STATUS_TOPIC = "status-topic";
  private static final String KAFKA_PROGRESS_TOPIC = "progress-topic";
  private static final String KAFKA_CONSUMER_GROUP = "group";
  private static final String HIBERNATE_CONFIGURATION = "hibernate-config";
  private static final String DEFAULT_KAFKA_GROUP = "job-histoty-group";
  private String server;
  private String registry;
  private String statusTopic;
  private String progressTopic;
  private String group;
  private String hibernateConfiguration;

  private CommandLineMenu createCommandLineMenu() {
    CommandLineMenu commandLine = new CommandLineMenu();
    commandLine.addOption("v", "version", "Print version information", OptionType.UNIQUE);
    commandLine.addOption(null, KAFKA_SERVER_ADDRESS, "Kafka server address", "ADDRESS", OptionType.MANDATORY);
    commandLine.addOption(null, KAFKA_SCHEMA_REGISTRY_URL, "Kafka schema registry URL", "URL", OptionType.MANDATORY);
    commandLine.addOption(null, KAFKA_STATUS_TOPIC, "Kafka job status topic", "NAME", OptionType.MANDATORY);
    commandLine.addOption(null, KAFKA_PROGRESS_TOPIC, "Kafka job progress topic", "NAME", OptionType.MANDATORY);
    commandLine.addOption(null, KAFKA_CONSUMER_GROUP, "Kafka consumer group (optional)", "NAME", OptionType.DEFAULT,
      DEFAULT_KAFKA_GROUP);
    commandLine.addOption(null, HIBERNATE_CONFIGURATION, "Comma-separated list of hibernate properties (optional)",
      "PROP1=VALUE1,PROP2=VALUE2,...", OptionType.OPTIONAL);
    return commandLine;
  }

  private void printErrorMsg(CommandLineMenu commandLine, String msgException) {
    HelpFormatter formatter = new HelpFormatter();
    Version version = new Version();
    String cmdLineSyntax = "java -jar soma-job-history-consumer-" + version.getVersion() + ".jar";
    cmdLineSyntax += "\n" + msgException;
    String header = "\n\nStart a job history consumer\n\n";
    formatter.printHelp(cmdLineSyntax, header, commandLine.getOptions(), null, true);
  }

  /**
   * Parser args from command line.
   * 
   * @param args from command line.
   * @return true if all mandatory are in args. otherwise, return false.
   *         False is return too when version is required in args.
   */
  public boolean parser(String[] args) {
    CommandLineMenu commandLine = createCommandLineMenu();
    Version version = new Version();
    try {
      commandLine.parser(args);
      if (commandLine.hasUnique()) {
        String unique = commandLine.getUnique();
        if (unique.equals("version")) {
          System.out.println(version.getVersion());
          return false;
        }
      }
      else {
        Map<String, String> mandatory = commandLine.getMandatory();
        Map<String, String> optionalAndDefault = commandLine.getOptionalAndDefault();
        this.server = mandatory.get(KAFKA_SERVER_ADDRESS);
        this.registry = mandatory.get(KAFKA_SCHEMA_REGISTRY_URL);
        this.statusTopic = mandatory.get(KAFKA_STATUS_TOPIC);
        this.progressTopic = mandatory.get(KAFKA_PROGRESS_TOPIC);
        this.group = optionalAndDefault.get(KAFKA_CONSUMER_GROUP);
        this.hibernateConfiguration = optionalAndDefault.get(HIBERNATE_CONFIGURATION);
        return true;
      }
    }
    catch (Exception e1) {
      printErrorMsg(commandLine, e1.getMessage());
    }
    return false;
  }

  public String getGroup() {
    return group;
  }

  public String getStatusTopic() {
    return statusTopic;
  }

  public String getProgressTopic() {
    return progressTopic;
  }

  public String getRegistry() {
    return registry;
  }

  public String getServer() {
    return server;
  }

  public String getHibernateConfiguration() {
    return hibernateConfiguration;
  }

}
