/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.configuration;

import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig
implements WebSocketMessageBrokerConfigurer {
    private final String BROKER_PREFIX_TYPE;
    private final String APPLICATION_DESTINATION_PREFIX;
    private final String ENDPOINT;

    @Autowired
    public WebSocketConfig(ServiceConfiguration serviceConfiguration) {
        this.BROKER_PREFIX_TYPE = serviceConfiguration.getValue(Constants.Config.WEBSOCKET_PREFIX_TYPE.option.getLongName());
        this.APPLICATION_DESTINATION_PREFIX = serviceConfiguration.getValue(Constants.Config.WEBSOCKET_APPLICATION_PREFIX.option.getLongName());
        this.ENDPOINT = serviceConfiguration.getValue(Constants.Config.WEBSOCKET_ENDPOINT.option.getLongName());
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{this.BROKER_PREFIX_TYPE});
        config.setApplicationDestinationPrefixes(new String[]{this.APPLICATION_DESTINATION_PREFIX});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.ENDPOINT}).withSockJS();
    }
}

