package br.pucrio.tecgraf.soma.job.application.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants.Config;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;

@Configuration
@EnableWebSocketMessageBroker
public class WebSocketConfig implements WebSocketMessageBrokerConfigurer {

  private final String BROKER_PREFIX_TYPE;
  private final String APPLICATION_DESTINATION_PREFIX;
  private final String ENDPOINT;

  @Autowired
  public WebSocketConfig(ServiceConfiguration serviceConfiguration) {
    this.BROKER_PREFIX_TYPE =
        serviceConfiguration.getValue(Config.WEBSOCKET_PREFIX_TYPE.option.getLongName());
    this.APPLICATION_DESTINATION_PREFIX =
        serviceConfiguration.getValue(Config.WEBSOCKET_APPLICATION_PREFIX.option.getLongName());
    this.ENDPOINT = serviceConfiguration.getValue(Config.WEBSOCKET_ENDPOINT.option.getLongName());
  }

  @Override
  public void configureMessageBroker(MessageBrokerRegistry config) {
    config.enableSimpleBroker(BROKER_PREFIX_TYPE);
    config.setApplicationDestinationPrefixes(APPLICATION_DESTINATION_PREFIX);
  }

  @Override
  public void registerStompEndpoints(StompEndpointRegistry registry) {
    registry.addEndpoint(ENDPOINT).withSockJS();
  }

}
