/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.endpoint;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.Flow;
import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobHistoryEvent;
import br.pucrio.tecgraf.soma.job.JobRescheduledEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.JobStageInEvent;
import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.job.domain.AlgorithmSpecificationVO;
import br.pucrio.tecgraf.soma.job.domain.JobEventVO;
import br.pucrio.tecgraf.soma.job.domain.StatusTypeVO;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.message.JobHistoryEventReader;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.avro.specific.SpecificRecordBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class JobEventWebSocket
implements Observer {
    private final String BROKER_PREFIX_TYPE;
    private final String TOPIC_NAME;
    private JobHistoryEventReader jobHistoryEventReader;
    private SimpMessagingTemplate websocketMessagingTemplate;

    @Autowired
    public JobEventWebSocket(JobHistoryEventReader jobHistoryEventReader, SimpMessagingTemplate websocketMessagingTemplate, ServiceConfiguration serviceConfiguration) {
        this.BROKER_PREFIX_TYPE = serviceConfiguration.getValue(Constants.Config.WEBSOCKET_PREFIX_TYPE.option.getLongName());
        this.TOPIC_NAME = serviceConfiguration.getValue(Constants.Config.WEBSOCKET_TOPIC_NAME.option.getLongName());
        this.jobHistoryEventReader = jobHistoryEventReader;
        this.websocketMessagingTemplate = websocketMessagingTemplate;
        this.jobHistoryEventReader.addObserver((Observer)this);
    }

    @Override
    public void update(Observable observable, Object arg) {
        SpecificRecordBase record = (SpecificRecordBase)((JobHistoryEvent)arg).getEvent();
        JobEventVO jobEvent = null;
        if (record instanceof JobStageInEvent) {
            jobEvent = this.createJobEvent((JobStageInEvent)record);
        } else if (record instanceof JobStageOutEvent) {
            jobEvent = this.createJobEvent((JobStageOutEvent)record);
        } else if (record instanceof JobExecutingEvent) {
            jobEvent = this.createJobEvent((JobExecutingEvent)record);
        } else if (record instanceof JobRescheduledEvent) {
            jobEvent = this.createJobEvent((JobRescheduledEvent)record);
        } else if (record instanceof JobScheduledEvent) {
            jobEvent = this.createJobEvent((JobScheduledEvent)record);
        } else if (record instanceof JobFinishedEvent) {
            jobEvent = this.createJobEvent((JobFinishedEvent)record);
        }
        if (jobEvent != null) {
            this.websocketMessagingTemplate.convertAndSend((Object)(this.BROKER_PREFIX_TYPE + this.TOPIC_NAME), (Object)jobEvent);
        }
    }

    private JobEventVO createJobEvent(JobStageInEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.UPDATE);
        jobEvent.setState(StatusTypeVO.UPLOADING.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }

    private JobEventVO createJobEvent(JobStageOutEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.UPDATE);
        jobEvent.setState(StatusTypeVO.DOWNLOADING.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }

    private JobEventVO createJobEvent(JobExecutingEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.UPDATE);
        jobEvent.setState(StatusTypeVO.EXECUTING.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setExecutionMachine(e.getExecutionMachine());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }

    private JobEventVO createJobEvent(JobRescheduledEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.UPDATE);
        jobEvent.setState(StatusTypeVO.RESCHEDULED.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }

    private JobEventVO createJobEvent(JobScheduledEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.CREATE);
        jobEvent.setState(StatusTypeVO.SCHEDULED.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setProjectId(e.getProjectId());
        jobEvent.setGroupId(e.getGroupId());
        if (e.getSpecificationType().toString().equals("ALGORITHM")) {
            Algorithm algo2 = (Algorithm)e.getSpecification();
            jobEvent.addAlgorithm(new AlgorithmSpecificationVO(algo2.getAlgorithmName(), algo2.getAlgorithmVersion()));
        } else {
            List algorithms = ((Flow)e.getSpecification()).getAlgorithms();
            algorithms.stream().map(algo -> new AlgorithmSpecificationVO(algo.getAlgorithmName(), algo.getAlgorithmVersion())).forEach(arg_0 -> ((JobEventVO)jobEvent).addAlgorithm(arg_0));
        }
        jobEvent.setDescription(e.getDescription());
        jobEvent.setPriority(e.getPriority());
        jobEvent.setSelectedMachines(e.getSelectedMachines());
        jobEvent.setSubmissionTime(e.getSubmissionTime());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }

    private JobEventVO createJobEvent(JobFinishedEvent e) {
        JobEventVO jobEvent = new JobEventVO();
        jobEvent.setType(JobEventVO.JobEventType.UPDATE);
        jobEvent.setState(StatusTypeVO.FINISHED.toString());
        jobEvent.setJobId(e.getJobId());
        jobEvent.setExitCode(e.getExitCode());
        jobEvent.setExitStatus(e.getExitStatus().toString());
        jobEvent.setExitCode(e.getExitCode());
        jobEvent.setCpuTime(e.getCpuTime());
        jobEvent.setWallclockTime(e.getWallclockTime());
        jobEvent.setTimestampType(e.getTimestamp());
        return jobEvent;
    }
}

