package br.pucrio.tecgraf.soma.job.application.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@Component
public class SocketHandler extends TextWebSocketHandler {

  List<WebSocketSession> sessions = new CopyOnWriteArrayList<>();

  public SocketHandler() {
    super();
  }

  @Override
  public void handleTextMessage(WebSocketSession session, TextMessage message)
  throws InterruptedException, IOException {

    for (WebSocketSession webSocketSession : sessions) {
      if (webSocketSession.isOpen()) {
        webSocketSession.sendMessage(message);
      }
      else {
        this.sessions.remove(webSocketSession);
      }
    }
  }

  public void sendMessage(String json_message) throws IOException, InterruptedException {
	  this.handleTextMessage(null, new TextMessage(json_message));

  }

  @Override
  public void afterConnectionEstablished(WebSocketSession session) throws Exception {
    this.sessions.add(session);
  }
} 