package br.pucrio.tecgraf.soma.job.application.appservice;

import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;

@Service
public class JobAppService {

  @Autowired
  private ServiceConfiguration config;

  /**
   * Busca os projetos que o usuário tem acesso via API REST do serviço de projetos do CSGrid.
   * @param accessToken o token para autenticação da chamada à API REST.
   * @return a lista de ids dos projetos que o usuário tem acesso.
   */
  public List<String> getUserProjects(String accessToken) throws NotFoundException {
    String csgridBaseURL = config.getValue(Constants.Config.CSGRID_BASE_URL.option.getLongName());
    Client client = ClientBuilder.newClient();
    WebTarget target = client.target(csgridBaseURL);

    String requestToken = "Bearer " + accessToken;
    Builder requestBuilder = target.path("projects").path("permissions").request(
      MediaType.APPLICATION_JSON).header(HttpHeaders.AUTHORIZATION, requestToken);

    Response response = requestBuilder.get();
      if (response.getStatus() != 200) {
      throw new NotFoundException("Error while trying to retrieve user projects: "
        +  response.getEntity(), response);
    }
    return response.readEntity(new GenericType<List<String>>() {});
  }
}
