package br.pucrio.tecgraf.soma.job.application.configuration;

import br.pucrio.tecgraf.soma.job.application.configuration.Constants.Config;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplicationContextConfig {

  private final Logger logger = LoggerFactory.getLogger(ApplicationContextConfig.class);

  @Bean
  public ServiceConfiguration serviceConfiguration(ApplicationArguments appArgs) {
    try {
      return ServiceConfiguration.build(Config.options(), appArgs.getSourceArgs(), true);
    } catch (ParseException e) {
      logger.error("Error parsing command line arguments", e);
    }
    throw new Error("Unrecoverable error parsing command line arguments.");
  }

}
