/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.event;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.ExitStatus;
import br.pucrio.tecgraf.soma.job.Flow;
import br.pucrio.tecgraf.soma.job.FlowNodeExitCode;
import br.pucrio.tecgraf.soma.job.JobExecutingEvent;
import br.pucrio.tecgraf.soma.job.JobFinishedEvent;
import br.pucrio.tecgraf.soma.job.JobRescheduledEvent;
import br.pucrio.tecgraf.soma.job.JobScheduledEvent;
import br.pucrio.tecgraf.soma.job.JobStageInEvent;
import br.pucrio.tecgraf.soma.job.JobStageOutEvent;
import br.pucrio.tecgraf.soma.job.SpecificationType;
import br.pucrio.tecgraf.soma.job.event.IJobHistoryEventFactory;
import br.pucrio.tecgraf.soma.job.util.CSBaseCommandUtil;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandInfo;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;

public class JobHistoryEventFactory
implements IJobHistoryEventFactory {
    private CommandPersistenceService persistenceService;

    public JobHistoryEventFactory(CommandPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public JobStageInEvent buildStageInEvent(ICommandInfo commandInfo) {
        JobStageInEvent stageInEvent = new JobStageInEvent();
        stageInEvent.setJobId(commandInfo.getCommandId());
        stageInEvent.setProjectId(commandInfo.getProjectId());
        stageInEvent.setEventId(UUID.randomUUID().toString());
        stageInEvent.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return stageInEvent;
    }

    @Override
    public JobStageOutEvent buildStageOutEvent(ICommandInfo commandInfo) {
        JobStageOutEvent stageOutEvent = new JobStageOutEvent();
        stageOutEvent.setJobId(commandInfo.getCommandId());
        stageOutEvent.setProjectId(commandInfo.getProjectId());
        stageOutEvent.setEventId(UUID.randomUUID().toString());
        stageOutEvent.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return stageOutEvent;
    }

    @Override
    public JobExecutingEvent buildExecutingEvent(ICommandInfo commandInfo) {
        CommandInfo csbaseCommandInfo = this.getCommandInfo(commandInfo);
        JobExecutingEvent executingEvent = new JobExecutingEvent();
        executingEvent.setJobId(commandInfo.getCommandId());
        executingEvent.setProjectId(commandInfo.getProjectId());
        executingEvent.setEventId(UUID.randomUUID().toString());
        executingEvent.setExecutionMachine(csbaseCommandInfo.getSGAName());
        executingEvent.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        return executingEvent;
    }

    @Override
    public JobRescheduledEvent buildRescheduledEvent(ICommandInfo commandInfo) {
        CommandInfo csbaseCommandInfo = this.getCommandInfo(commandInfo);
        JobRescheduledEvent rescheduledEvent = new JobRescheduledEvent();
        rescheduledEvent.setJobId(commandInfo.getCommandId());
        rescheduledEvent.setProjectId(commandInfo.getProjectId());
        rescheduledEvent.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        rescheduledEvent.setEventId(UUID.randomUUID().toString());
        rescheduledEvent.setNumberOfRetries(csbaseCommandInfo.getSubmissionAttempts());
        return rescheduledEvent;
    }

    @Override
    public JobScheduledEvent buildScheduledEvent(ICommandInfo commandInfo) {
        CommandInfo csbaseCommandInfo = this.getCommandInfo(commandInfo);
        JobScheduledEvent scheduledEvent = new JobScheduledEvent();
        scheduledEvent.setAutomaticallyMachineSelection(Boolean.valueOf(csbaseCommandInfo.isAutomatic()));
        scheduledEvent.setJobId(commandInfo.getCommandId());
        scheduledEvent.setOwner(csbaseCommandInfo.getUserId().toString());
        try {
            AlgorithmConfigurator algoConf = csbaseCommandInfo.getConfigurator();
            if (this.isFlow(algoConf)) {
                Flow flow = this.buildFlowObject(algoConf);
                scheduledEvent.setSpecificationType(SpecificationType.FLOW);
                scheduledEvent.setSpecification((Object)flow);
            } else {
                Algorithm algorithm = this.createAlgorithmFromConfig(algoConf);
                scheduledEvent.setSpecificationType(SpecificationType.ALGORITHM);
                scheduledEvent.setSpecification((Object)algorithm);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        String description = csbaseCommandInfo.getDescription();
        if (description == null) {
            scheduledEvent.setDescription("");
        } else {
            scheduledEvent.setDescription(description);
        }
        scheduledEvent.setEventId(UUID.randomUUID().toString());
        scheduledEvent.setGroupId(csbaseCommandInfo.getGroupId());
        scheduledEvent.setMultipleExecution(Boolean.valueOf(csbaseCommandInfo.getExecutionType() == ExecutionType.MULTIPLE));
        Integer execCount = csbaseCommandInfo.getExecutionCountForMultipleExecution();
        if (execCount == null) {
            execCount = 1;
        }
        scheduledEvent.setNumberOfProcesses(execCount);
        Integer execCountBtMachine = csbaseCommandInfo.getExecutionCountPerSGAForMultipleExecution();
        if (execCountBtMachine == null) {
            execCountBtMachine = 1;
        }
        scheduledEvent.setNumberOfProcessesByMachine(execCountBtMachine);
        scheduledEvent.setPriority(Integer.valueOf(csbaseCommandInfo.getPriority().ordinal()));
        scheduledEvent.setProjectId(commandInfo.getProjectId());
        scheduledEvent.setSelectedMachines(Arrays.asList(csbaseCommandInfo.getSelectedSGAsNames().toArray(new String[0])));
        scheduledEvent.setSubmissionTime(Long.valueOf(csbaseCommandInfo.getSubmittedDate().getTime()));
        scheduledEvent.setTimestamp(Long.valueOf(csbaseCommandInfo.getSubmittedDate().getTime()));
        return scheduledEvent;
    }

    @Override
    public JobFinishedEvent buildFinishedEvent(ICommandInfo commandInfo) {
        CommandInfo csbaseCommandInfo = this.getCommandInfo(commandInfo);
        JobFinishedEvent finishedEvent = new JobFinishedEvent();
        finishedEvent.setJobId(commandInfo.getCommandId());
        finishedEvent.setProjectId(commandInfo.getProjectId());
        long currentTimeMillis = System.currentTimeMillis();
        finishedEvent.setEndTime(Long.valueOf(currentTimeMillis));
        Double cpuTimeSec = csbaseCommandInfo.getCpuTimeSec();
        if (cpuTimeSec == null) {
            cpuTimeSec = 0.0;
        }
        finishedEvent.setCpuTime(Long.valueOf(cpuTimeSec.longValue()));
        finishedEvent.setEventId(UUID.randomUUID().toString());
        finishedEvent.setExitCode(csbaseCommandInfo.getFinalizationInfo().getExitCode());
        finishedEvent.setExitStatus(CSBaseCommandUtil.getExitStatusFromInfo(csbaseCommandInfo.getFinalizationInfo()));
        finishedEvent.setGuiltyNodeId(commandInfo.getGuiltyNodeId());
        try {
            AlgorithmConfigurator algoConf = csbaseCommandInfo.getConfigurator();
            LinkedList<FlowNodeExitCode> exitCodes = new LinkedList<FlowNodeExitCode>();
            if (this.isFlow(algoConf)) {
                FlowAlgorithmConfigurator flowConf = (FlowAlgorithmConfigurator)algoConf;
                Set nodes = flowConf.getFlow().getNodes();
                if (csbaseCommandInfo.getFinalizationInfo().getInfoType() == CommandFinalizationInfo.FinalizationInfoType.EXTENDED) {
                    ExtendedCommandFinalizationInfo extendedFinalization = (ExtendedCommandFinalizationInfo)csbaseCommandInfo.getFinalizationInfo();
                    for (FlowNode node : nodes) {
                        if (node.isBypassed()) continue;
                        int id = node.getId();
                        Integer exitCode = extendedFinalization.getFinalizationInfoForNode(id).getExitCode();
                        exitCodes.add(new FlowNodeExitCode(Integer.valueOf(id), exitCode));
                    }
                } else {
                    exitCodes.add(new FlowNodeExitCode(Integer.valueOf(0), csbaseCommandInfo.getFinalizationInfo().getExitCode()));
                }
            } else {
                exitCodes.add(new FlowNodeExitCode(Integer.valueOf(0), csbaseCommandInfo.getFinalizationInfo().getExitCode()));
            }
            finishedEvent.setFlowNodeIdExitCode(exitCodes);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        finishedEvent.setTimestamp(Long.valueOf(currentTimeMillis));
        Integer wallTimeSec = csbaseCommandInfo.getWallTimeSec();
        if (wallTimeSec == null) {
            wallTimeSec = 0;
        }
        finishedEvent.setWallclockTime(Long.valueOf(wallTimeSec.longValue()));
        return finishedEvent;
    }

    protected boolean isFlow(AlgorithmConfigurator algoConf) {
        return algoConf.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW;
    }

    protected Algorithm createAlgorithmFromConfig(AlgorithmConfigurator algoConf) {
        return CSBaseCommandUtil.createAlgorithmFromConfig(algoConf);
    }

    protected ExitStatus convertToJobExitStatus(CommandFinalizationInfo finalizationInfo) {
        return CSBaseCommandUtil.getExitStatusFromInfo(finalizationInfo);
    }

    protected CommandInfo getCommandInfo(ICommandInfo commandInfo) {
        return this.persistenceService.getCommandInfo((Object)commandInfo.getProjectId(), commandInfo.getCommandId());
    }

    protected Flow buildFlowObject(AlgorithmConfigurator algoConf) {
        FlowAlgorithmConfigurator flowConf = (FlowAlgorithmConfigurator)algoConf;
        Flow flow = CSBaseCommandUtil.createFlowFromConfig(flowConf);
        return flow;
    }
}

