/**
 * Autogenerated by Avro
 *
 * DO NOT EDIT DIRECTLY
 */
package br.pucrio.tecgraf.soma.job;

import org.apache.avro.specific.SpecificData;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.SchemaStore;

@SuppressWarnings("all")
/** Avro Schema for the job history events. */
@org.apache.avro.specific.AvroGenerated
public class JobHistoryEvent extends org.apache.avro.specific.SpecificRecordBase implements org.apache.avro.specific.SpecificRecord {
  private static final long serialVersionUID = 3977447480429207385L;
  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser().parse("{\"type\":\"record\",\"name\":\"JobHistoryEvent\",\"namespace\":\"br.pucrio.tecgraf.soma.job\",\"doc\":\"Avro Schema for the job history events.\",\"fields\":[{\"name\":\"eventName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the event\",\"default\":\"UNKNOWN\"},{\"name\":\"event\",\"type\":[{\"type\":\"record\",\"name\":\"AnyJobEvent\",\"doc\":\"Avro Schema for default job event.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobScheduledEvent\",\"doc\":\"Avro Schema for the event of job scheduled. All the information came from the job submission.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"groupId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Job group identifier\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"owner\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Owner's user identifier\",\"default\":\"\"},{\"name\":\"automaticallyMachineSelection\",\"type\":\"boolean\",\"doc\":\"Flag to indicate option for automatically machine selection\",\"default\":false},{\"name\":\"selectedMachines\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Machines that user selected for execution.\",\"default\":[]},{\"name\":\"numberOfProcesses\",\"type\":\"int\",\"doc\":\"The total number of processes. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"numberOfProcessesByMachine\",\"type\":\"int\",\"doc\":\"The number of processes by machine. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"submissionTime\",\"type\":\"long\",\"doc\":\"The timestamp of job submission.\",\"default\":0},{\"name\":\"description\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job description.\",\"default\":\"\"},{\"name\":\"priority\",\"type\":\"int\",\"doc\":\"Execution priority.\",\"default\":0},{\"name\":\"multipleExecution\",\"type\":\"boolean\",\"doc\":\"If the submission will create multiple jobs.\",\"default\":false},{\"name\":\"specificationType\",\"type\":{\"type\":\"enum\",\"name\":\"SpecificationType\",\"symbols\":[\"ALGORITHM\",\"FLOW\"]},\"default\":\"ALGORITHM\"},{\"name\":\"specification\",\"type\":[{\"type\":\"record\",\"name\":\"Algorithm\",\"doc\":\"Avro Schema for algorithm parameters.\",\"fields\":[{\"name\":\"algorithmId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm identifier.\",\"default\":\"\"},{\"name\":\"algorithmVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm version.\",\"default\":\"\"},{\"name\":\"algorithmName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm name.\",\"default\":\"\"},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AlgorithmParameter\",\"doc\":\"Avro Schema for algorithm parameter.\",\"fields\":[{\"name\":\"parameterId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter identifier.\",\"default\":\"\"},{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter label.\",\"default\":\"\"},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter type.\",\"default\":\"\"},{\"name\":\"value\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The parameter value.\",\"default\":\"null\"}],\"version\":\"1\"}},\"doc\":\"The algorithm parameters.\",\"default\":[]},{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id (it helps to identify same algorithms inside a flow)\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"Flow\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow identifier.\",\"default\":\"\"},{\"name\":\"flowVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow version.\",\"default\":\"\"},{\"name\":\"flowName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow name.\",\"default\":\"\"},{\"name\":\"raw\",\"type\":\"bytes\",\"doc\":\"The flow raw configurator.\",\"default\":\"\"},{\"name\":\"algorithms\",\"type\":{\"type\":\"array\",\"items\":\"Algorithm\"},\"doc\":\"The parameters for each algorithm in the flow.\",\"default\":[]}],\"version\":\"1\"}],\"doc\":\"If the job is related to an algorithm or to a flow.\",\"default\":\"br.pucrio.tecgraf.soma.job.Algorithm\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobStageInEvent\",\"doc\":\"Avro Schema for the event of stage-in.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobStageOutEvent\",\"doc\":\"Avro Schema for the event of stage-out.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobRescheduledEvent\",\"doc\":\"Avro Schema for the event of job re-scheduled.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"numberOfRetries\",\"type\":\"int\",\"doc\":\"The number of times the job has already being re-schedule. This value is updated by each re-schedule event.\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobExecutingEvent\",\"doc\":\"Avro Schema for executing job event\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"executionMachine\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The machine where the job is executing.\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobFinishedEvent\",\"doc\":\"Avro Schema for the event of job finished.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"exitCode\",\"type\":[\"null\",\"int\"],\"doc\":\"The job exit code.\",\"default\":null},{\"name\":\"flowNodeIdExitCode\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"FlowNodeExitCode\",\"fields\":[{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id (it helps to identif","y same algorithms inside a flow)\",\"default\":0},{\"name\":\"exitCode\",\"type\":[\"null\",\"int\"],\"doc\":\"The job exit code.\",\"default\":null}],\"version\":\"1\"}},\"doc\":\"Exit code of the flow nodes.\",\"default\":[]},{\"name\":\"guiltyNodeId\",\"type\":[\"null\",\"int\"],\"doc\":\"The id of the algorithm (flow node) that caused the job to finish earlier than expected.\",\"default\":null},{\"name\":\"exitStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExitStatus\",\"doc\":\"The possible values for finished job status.\",\"symbols\":[\"UNKNOWN\",\"SUCCESS\",\"EXECUTION_ERROR\",\"COMMAND_IDENTIFIER_NOT_FOUND\",\"UNEXPECTED_MACHINE_ERROR\",\"PROJECT_NOT_FOUND\",\"FAILED_SETUP_EXECUTION_ENVIRONMENT\",\"NO_PERMISSION\",\"NO_MACHINE_AVAILABLE\",\"KILLED\",\"LOST\",\"UNDEFINED\"],\"version\":\"1\"},\"doc\":\"The status of the job after execution.\",\"default\":\"UNKNOWN\"},{\"name\":\"wallclockTime\",\"type\":\"long\",\"doc\":\"The actual amount of time taken to run the job.\",\"default\":0},{\"name\":\"cpuTime\",\"type\":\"long\",\"doc\":\"The amount of time for which a CPU was used for processing the job.\",\"default\":0},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"The timestamp when the job finished\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobProgressEvent\",\"doc\":\"Avro Schema for event of the progress of a executing job\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"jobProgress\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Execution progress of the Job\",\"default\":null},{\"name\":\"nodesProgress\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"NodeProgress\",\"doc\":\"Avro Schema for flow node progress.\",\"fields\":[{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id\",\"default\":0},{\"name\":\"flowNodeProgress\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Execution progress of the flow node\",\"default\":null}],\"version\":\"1\"}},\"doc\":\"Progresses of the flow nodes\",\"default\":[]}],\"version\":\"1\"}],\"default\":\"br.pucrio.tecgraf.soma.job.AnyJobEvent\"}],\"version\":\"1\"}");
  public static org.apache.avro.Schema getClassSchema() { return SCHEMA$; }

  private static SpecificData MODEL$ = new SpecificData();

  private static final BinaryMessageEncoder<JobHistoryEvent> ENCODER =
      new BinaryMessageEncoder<JobHistoryEvent>(MODEL$, SCHEMA$);

  private static final BinaryMessageDecoder<JobHistoryEvent> DECODER =
      new BinaryMessageDecoder<JobHistoryEvent>(MODEL$, SCHEMA$);

  /**
   * Return the BinaryMessageDecoder instance used by this class.
   */
  public static BinaryMessageDecoder<JobHistoryEvent> getDecoder() {
    return DECODER;
  }

  /**
   * Create a new BinaryMessageDecoder instance for this class that uses the specified {@link SchemaStore}.
   * @param resolver a {@link SchemaStore} used to find schemas by fingerprint
   */
  public static BinaryMessageDecoder<JobHistoryEvent> createDecoder(SchemaStore resolver) {
    return new BinaryMessageDecoder<JobHistoryEvent>(MODEL$, SCHEMA$, resolver);
  }

  /** Serializes this JobHistoryEvent to a ByteBuffer. */
  public java.nio.ByteBuffer toByteBuffer() throws java.io.IOException {
    return ENCODER.encode(this);
  }

  /** Deserializes a JobHistoryEvent from a ByteBuffer. */
  public static JobHistoryEvent fromByteBuffer(
      java.nio.ByteBuffer b) throws java.io.IOException {
    return DECODER.decode(b);
  }

  /** The name of the event */
  @Deprecated public java.lang.String eventName;
  @Deprecated public java.lang.Object event;

  /**
   * Default constructor.  Note that this does not initialize fields
   * to their default values from the schema.  If that is desired then
   * one should use <code>newBuilder()</code>.
   */
  public JobHistoryEvent() {}

  /**
   * All-args constructor.
   * @param eventName The name of the event
   * @param event The new value for event
   */
  public JobHistoryEvent(java.lang.String eventName, java.lang.Object event) {
    this.eventName = eventName;
    this.event = event;
  }

  public org.apache.avro.Schema getSchema() { return SCHEMA$; }
  // Used by DatumWriter.  Applications should not call.
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0: return eventName;
    case 1: return event;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  // Used by DatumReader.  Applications should not call.
  @SuppressWarnings(value="unchecked")
  public void put(int field$, java.lang.Object value$) {
    switch (field$) {
    case 0: eventName = (java.lang.String)value$; break;
    case 1: event = (java.lang.Object)value$; break;
    default: throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  /**
   * Gets the value of the 'eventName' field.
   * @return The name of the event
   */
  public java.lang.String getEventName() {
    return eventName;
  }

  /**
   * Sets the value of the 'eventName' field.
   * The name of the event
   * @param value the value to set.
   */
  public void setEventName(java.lang.String value) {
    this.eventName = value;
  }

  /**
   * Gets the value of the 'event' field.
   * @return The value of the 'event' field.
   */
  public java.lang.Object getEvent() {
    return event;
  }

  /**
   * Sets the value of the 'event' field.
   * @param value the value to set.
   */
  public void setEvent(java.lang.Object value) {
    this.event = value;
  }

  /**
   * Creates a new JobHistoryEvent RecordBuilder.
   * @return A new JobHistoryEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder newBuilder() {
    return new br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder();
  }

  /**
   * Creates a new JobHistoryEvent RecordBuilder by copying an existing Builder.
   * @param other The existing builder to copy.
   * @return A new JobHistoryEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder newBuilder(br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder other) {
    return new br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder(other);
  }

  /**
   * Creates a new JobHistoryEvent RecordBuilder by copying an existing JobHistoryEvent instance.
   * @param other The existing instance to copy.
   * @return A new JobHistoryEvent RecordBuilder
   */
  public static br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder newBuilder(br.pucrio.tecgraf.soma.job.JobHistoryEvent other) {
    return new br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder(other);
  }

  /**
   * RecordBuilder for JobHistoryEvent instances.
   */
  public static class Builder extends org.apache.avro.specific.SpecificRecordBuilderBase<JobHistoryEvent>
    implements org.apache.avro.data.RecordBuilder<JobHistoryEvent> {

    /** The name of the event */
    private java.lang.String eventName;
    private java.lang.Object event;

    /** Creates a new Builder */
    private Builder() {
      super(SCHEMA$);
    }

    /**
     * Creates a Builder by copying an existing Builder.
     * @param other The existing Builder to copy.
     */
    private Builder(br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder other) {
      super(other);
      if (isValidValue(fields()[0], other.eventName)) {
        this.eventName = data().deepCopy(fields()[0].schema(), other.eventName);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.event)) {
        this.event = data().deepCopy(fields()[1].schema(), other.event);
        fieldSetFlags()[1] = true;
      }
    }

    /**
     * Creates a Builder by copying an existing JobHistoryEvent instance
     * @param other The existing instance to copy.
     */
    private Builder(br.pucrio.tecgraf.soma.job.JobHistoryEvent other) {
            super(SCHEMA$);
      if (isValidValue(fields()[0], other.eventName)) {
        this.eventName = data().deepCopy(fields()[0].schema(), other.eventName);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.event)) {
        this.event = data().deepCopy(fields()[1].schema(), other.event);
        fieldSetFlags()[1] = true;
      }
    }

    /**
      * Gets the value of the 'eventName' field.
      * The name of the event
      * @return The value.
      */
    public java.lang.String getEventName() {
      return eventName;
    }

    /**
      * Sets the value of the 'eventName' field.
      * The name of the event
      * @param value The value of 'eventName'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder setEventName(java.lang.String value) {
      validate(fields()[0], value);
      this.eventName = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /**
      * Checks whether the 'eventName' field has been set.
      * The name of the event
      * @return True if the 'eventName' field has been set, false otherwise.
      */
    public boolean hasEventName() {
      return fieldSetFlags()[0];
    }


    /**
      * Clears the value of the 'eventName' field.
      * The name of the event
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder clearEventName() {
      eventName = null;
      fieldSetFlags()[0] = false;
      return this;
    }

    /**
      * Gets the value of the 'event' field.
      * @return The value.
      */
    public java.lang.Object getEvent() {
      return event;
    }

    /**
      * Sets the value of the 'event' field.
      * @param value The value of 'event'.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder setEvent(java.lang.Object value) {
      validate(fields()[1], value);
      this.event = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /**
      * Checks whether the 'event' field has been set.
      * @return True if the 'event' field has been set, false otherwise.
      */
    public boolean hasEvent() {
      return fieldSetFlags()[1];
    }


    /**
      * Clears the value of the 'event' field.
      * @return This builder.
      */
    public br.pucrio.tecgraf.soma.job.JobHistoryEvent.Builder clearEvent() {
      event = null;
      fieldSetFlags()[1] = false;
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public JobHistoryEvent build() {
      try {
        JobHistoryEvent record = new JobHistoryEvent();
        record.eventName = fieldSetFlags()[0] ? this.eventName : (java.lang.String) defaultValue(fields()[0]);
        record.event = fieldSetFlags()[1] ? this.event : (java.lang.Object) defaultValue(fields()[1]);
        return record;
      } catch (java.lang.Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumWriter<JobHistoryEvent>
    WRITER$ = (org.apache.avro.io.DatumWriter<JobHistoryEvent>)MODEL$.createDatumWriter(SCHEMA$);

  @Override public void writeExternal(java.io.ObjectOutput out)
    throws java.io.IOException {
    WRITER$.write(this, SpecificData.getEncoder(out));
  }

  @SuppressWarnings("unchecked")
  private static final org.apache.avro.io.DatumReader<JobHistoryEvent>
    READER$ = (org.apache.avro.io.DatumReader<JobHistoryEvent>)MODEL$.createDatumReader(SCHEMA$);

  @Override public void readExternal(java.io.ObjectInput in)
    throws java.io.IOException {
    READER$.read(this, SpecificData.getDecoder(in));
  }

}
