/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class JobHistoryEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4552465848582385112L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"JobHistoryEvent\",\"namespace\":\"br.pucrio.tecgraf.soma.job\",\"doc\":\"Avro Schema for the job history events.\",\"fields\":[{\"name\":\"eventName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the event\",\"default\":\"UNKNOWN\"},{\"name\":\"event\",\"type\":[{\"type\":\"record\",\"name\":\"AnyJobEvent\",\"doc\":\"Avro Schema for default job event.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobScheduledEvent\",\"doc\":\"Avro Schema for the event of job scheduled. All the information came from the job submission.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"groupId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Job group identifier\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"owner\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Owner's user identifier\",\"default\":\"\"},{\"name\":\"automaticallyMachineSelection\",\"type\":\"boolean\",\"doc\":\"Flag to indicate option for automatically machine selection\",\"default\":false},{\"name\":\"selectedMachines\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Machines that user selected for execution.\",\"default\":[]},{\"name\":\"dependencyIds\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Array of job ids that need to successfully finish for this one to run.\",\"default\":[]},{\"name\":\"numberOfProcesses\",\"type\":\"int\",\"doc\":\"The total number of processes. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"numberOfProcessesByMachine\",\"type\":\"int\",\"doc\":\"The number of processes by machine. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"submissionTime\",\"type\":\"long\",\"doc\":\"The timestamp of job submission.\",\"default\":0},{\"name\":\"description\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job description.\",\"default\":\"\"},{\"name\":\"priority\",\"type\":\"int\",\"doc\":\"Execution priority.\",\"default\":0},{\"name\":\"multipleExecution\",\"type\":\"boolean\",\"doc\":\"If the submission will create multiple jobs.\",\"default\":false},{\"name\":\"specificationType\",\"type\":{\"type\":\"enum\",\"name\":\"SpecificationType\",\"symbols\":[\"ALGORITHM\",\"FLOW\"]},\"default\":\"ALGORITHM\"},{\"name\":\"specification\",\"type\":[{\"type\":\"record\",\"name\":\"Algorithm\",\"doc\":\"Avro Schema for algorithm parameters.\",\"fields\":[{\"name\":\"algorithmId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm identifier.\",\"default\":\"\"},{\"name\":\"algorithmVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm version.\",\"default\":\"\"},{\"name\":\"algorithmName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm name.\",\"default\":\"\"},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AlgorithmParameter\",\"doc\":\"Avro Schema for algorithm parameter.\",\"fields\":[{\"name\":\"parameterId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter identifier.\",\"default\":\"\"},{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter label.\",\"default\":\"\"},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter type.\",\"default\":\"\"},{\"name\":\"value\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The parameter value.\",\"default\":\"null\"}],\"version\":\"1\"}},\"doc\":\"The algorithm parameters.\",\"default\":[]},{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id (it helps to identify same algorithms inside a flow)\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"Flow\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow identifier.\",\"default\":\"\"},{\"name\":\"flowVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow version.\",\"default\":\"\"},{\"name\":\"flowName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow name.\",\"default\":\"\"},{\"name\":\"raw\",\"type\":\"bytes\",\"doc\":\"The flow raw configurator.\",\"default\":\"\"},{\"name\":\"algorithms\",\"type\":{\"type\":\"array\",\"items\":\"Algorithm\"},\"doc\":\"The parameters for each algorithm in the flow.\",\"default\":[]}],\"version\":\"1\"}],\"doc\":\"If the job is related to an algorithm or to a flow.\",\"default\":\"br.pucrio.tecgraf.soma.job.Algorithm\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobStageInEvent\",\"doc\":\"Avro Schema for the event of stage-in.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobStageOutEvent\",\"doc\":\"Avro Schema for the event of stage-out.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobRescheduledEvent\",\"doc\":\"Avro Schema for the event of job re-scheduled.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"numberOfRetries\",\"type\":\"int\",\"doc\":\"The number of times the job has already being re-schedule. This value is updated by each re-schedule event.\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobExecutingEvent\",\"doc\":\"Avro Schema for executing job event\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"executionMachine\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The machine where the job is executing.\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobFinishedEvent\",\"doc\":\"Avro Schema for the event of job finished.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"exitCode\",\"type\":[\"null\",\"int\"],\"doc\":\"The job exit code.\",\"default\":nu", new String[]{"ll},{\"name\":\"flowNodeIdExitCode\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"FlowNodeExitCode\",\"fields\":[{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id (it helps to identify same algorithms inside a flow)\",\"default\":0},{\"name\":\"exitCode\",\"type\":[\"null\",\"int\"],\"doc\":\"The job exit code.\",\"default\":null}],\"version\":\"1\"}},\"doc\":\"Exit code of the flow nodes.\",\"default\":[]},{\"name\":\"guiltyNodeId\",\"type\":[\"null\",\"int\"],\"doc\":\"The id of the algorithm (flow node) that caused the job to finish earlier than expected.\",\"default\":null},{\"name\":\"exitStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExitStatus\",\"doc\":\"The possible values for finished job status.\",\"symbols\":[\"UNKNOWN\",\"SUCCESS\",\"EXECUTION_ERROR\",\"COMMAND_IDENTIFIER_NOT_FOUND\",\"UNEXPECTED_MACHINE_ERROR\",\"PROJECT_NOT_FOUND\",\"FAILED_SETUP_EXECUTION_ENVIRONMENT\",\"NO_PERMISSION\",\"NO_MACHINE_AVAILABLE\",\"KILLED\",\"LOST\",\"UNDEFINED\",\"NO_EXIT_CODE\",\"DEPENDENCE_ERROR\",\"UNKNOWN_FAILURE\",\"UNDEFINED_FAILURE\"],\"version\":\"1\"},\"doc\":\"The status of the job after execution.\",\"default\":\"UNKNOWN\"},{\"name\":\"wallclockTime\",\"type\":\"long\",\"doc\":\"The actual amount of time taken to run the job.\",\"default\":0},{\"name\":\"cpuTime\",\"type\":\"long\",\"doc\":\"The amount of time for which a CPU was used for processing the job.\",\"default\":0},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"The timestamp when the job finished\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobProgressEvent\",\"doc\":\"Avro Schema for event of the progress of a executing job\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"jobProgress\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Execution progress of the Job\",\"default\":null},{\"name\":\"nodesProgress\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"NodeProgress\",\"doc\":\"Avro Schema for flow node progress.\",\"fields\":[{\"name\":\"flowNodeId\",\"type\":\"int\",\"doc\":\"The flow node id\",\"default\":0},{\"name\":\"flowNodeProgress\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Execution progress of the flow node\",\"default\":null}],\"version\":\"1\"}},\"doc\":\"Progresses of the flow nodes\",\"default\":[]}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"JobInitEvent\",\"doc\":\"Avro Schema for the event of job initialization.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The job event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The job event timestamp\",\"default\":0},{\"name\":\"jobId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the job\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"}],\"version\":\"1\"}],\"default\":\"br.pucrio.tecgraf.soma.job.AnyJobEvent\"}],\"version\":\"1\"}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<JobHistoryEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<JobHistoryEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String eventName;
    @Deprecated
    public Object event;
    private static final DatumWriter<JobHistoryEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<JobHistoryEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<JobHistoryEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<JobHistoryEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static JobHistoryEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (JobHistoryEvent)((Object)DECODER.decode(b));
    }

    public JobHistoryEvent() {
    }

    public JobHistoryEvent(String eventName, Object event) {
        this.eventName = eventName;
        this.event = event;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.eventName;
            }
            case 1: {
                return this.event;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.eventName = (String)value$;
                break;
            }
            case 1: {
                this.event = value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String value) {
        this.eventName = value;
    }

    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object value) {
        this.event = value;
    }

    public static Builder newBuilder() {
        return new Builder(null, null);
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other, null, null);
    }

    public static Builder newBuilder(JobHistoryEvent other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<JobHistoryEvent>
    implements RecordBuilder<JobHistoryEvent> {
        private String eventName;
        private Object event;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.eventName)) {
                this.eventName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.eventName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event)) {
                this.event = this.data().deepCopy(this.fields()[1].schema(), other.event);
                this.fieldSetFlags()[1] = true;
            }
        }

        private Builder(JobHistoryEvent other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.eventName)) {
                this.eventName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.eventName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event)) {
                this.event = this.data().deepCopy(this.fields()[1].schema(), other.event);
                this.fieldSetFlags()[1] = true;
            }
        }

        public String getEventName() {
            return this.eventName;
        }

        public Builder setEventName(String value) {
            this.validate(this.fields()[0], value);
            this.eventName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasEventName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearEventName() {
            this.eventName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Object getEvent() {
            return this.event;
        }

        public Builder setEvent(Object value) {
            this.validate(this.fields()[1], value);
            this.event = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEvent() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEvent() {
            this.event = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public JobHistoryEvent build() {
            try {
                JobHistoryEvent record = new JobHistoryEvent();
                record.eventName = this.fieldSetFlags()[0] ? this.eventName : (String)this.defaultValue(this.fields()[0]);
                record.event = this.fieldSetFlags()[1] ? this.event : this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }

        /* synthetic */ Builder(Builder builder, Builder builder2) {
            this();
        }

        /* synthetic */ Builder(Builder builder, Builder builder2, Builder builder3) {
            this(builder);
        }
    }
}

