package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.model.Job;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.List;

@Component
public class JobController extends JobsApi {

  @Autowired private JobAppService jobAppService;

  public JobController() {
    super(null);
  }

  @Override
  public Response jobsDelete(List<String> jobIds, String locale, SecurityContext securityContext)
      throws NotFoundException {
    jobAppService.markJobsAsDeleted(jobIds);
    return Response.status(Response.Status.NO_CONTENT).build();
  }

  @Override
  public Response jobsGet(
      String q,
      Integer offset,
      Integer limit,
      Boolean asc,
      String attr,
      Boolean showParam,
      String locale,
      SecurityContext securityContext)
      throws NotFoundException {
    if (limit != null && limit <= 0) {
      return Response.status(HttpStatus.BAD_REQUEST.value(), "Limit must be a positive number")
          .build();
    }
    if (offset != null && offset < 0) {
      return Response.status(
              HttpStatus.BAD_REQUEST.value(), "Offset must be a positive number or zero")
          .build();
    }
    if (offset != null && limit == null) {
      return Response.status(HttpStatus.BAD_REQUEST.value(), "Limit is mandatory using offset")
          .build();
    }

    String notDeletedQuery = "isDeleted==false"; // por padrao só retornaremos os jobs não deletados
    if (q == null || q.length() == 0 ) { // caso de query vazia
      q = notDeletedQuery;
    } else if( q.contains("isDeleted") == false ) { // se a busca não for pelo atributo isDeleted
      q = String.format("(%s);(%s)",q, notDeletedQuery);
    }

    Tuple<List<br.pucrio.tecgraf.soma.job.domain.model.Job>, Integer> tuple = jobAppService.findJobs(q, offset, limit, asc, attr);

    if (!showParam) {
      for (br.pucrio.tecgraf.soma.job.domain.model.Job job : tuple.getFirst()) {
        for (JobAlgorithm algorithm : job.getAlgorithms()) {
          algorithm.getParameters().clear();
        }
      }
    }

    JobData data = new JobData();
    data.processingDate(System.currentTimeMillis());
    data.jobs(Arrays.asList(DomainMapper.convert(tuple.getFirst(), Job[].class)));

    JobResponse response = new JobResponse();
    response.data(data);
    response.pagination(jobAppService.buildPaginationInfo(tuple.getSecond(), offset, limit));

    return Response.ok().entity(response).build();
  }
}
