/*
 * Job History Service
 * Job History Search API
 *
 * OpenAPI spec version: 1.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package br.pucrio.tecgraf.soma.job.api.model;

import java.util.Objects;
import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.StatusChangeHistory;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * Job
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2019-12-03T21:04:58.208Z[Etc/UTC]")
public class Job   {
  @JsonProperty("jobId")
  private String jobId;

  @JsonProperty("groupId")
  private String groupId;

  @JsonProperty("projectId")
  private String projectId;

  @JsonProperty("jobOwner")
  private String jobOwner;

  @JsonProperty("automaticallyMachineSelection")
  private Boolean automaticallyMachineSelection;

  @JsonProperty("submissionMachines")
  private List<String> submissionMachines = null;

  @JsonProperty("numberOfProcesses")
  private Integer numberOfProcesses;

  @JsonProperty("numberOfProcessesByMachine")
  private Integer numberOfProcessesByMachine;

  @JsonProperty("submissionTime")
  private String submissionTime;

  @JsonProperty("description")
  private String description;

  @JsonProperty("priority")
  private Integer priority;

  @JsonProperty("multipleExecution")
  private Boolean multipleExecution;

  @JsonProperty("jobType")
  private JobType jobType = null;

  @JsonProperty("numberOfAttempts")
  private Integer numberOfAttempts;

  @JsonProperty("executionMachine")
  private String executionMachine;

  @JsonProperty("endTime")
  private String endTime;

  @JsonProperty("exitCode")
  private Integer exitCode;

  @JsonProperty("guiltyNodeId")
  private String guiltyNodeId;

  @JsonProperty("exitStatus")
  private ExitStatus exitStatus = null;

  @JsonProperty("cpuTime")
  private Double cpuTime;

  @JsonProperty("wallclockTime")
  private Integer wallclockTime;

  @JsonProperty("ramMemory")
  private Double ramMemory;

  @JsonProperty("statusHistory")
  private List<StatusChangeHistory> statusHistory = null;

  @JsonProperty("algorithms")
  private List<Algorithm> algorithms = null;

  @JsonProperty("flowId")
  private String flowId;

  @JsonProperty("flowVersion")
  private String flowVersion;

  @JsonProperty("flowName")
  private String flowName;

  @JsonProperty("lastModifiedTime")
  private String lastModifiedTime;

  public Job jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The job Id.
   * @return jobId
   **/
  @JsonProperty("jobId")
  @ApiModelProperty(value = "The job Id.")
  
  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public Job groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * The group Id of the job.
   * @return groupId
   **/
  @JsonProperty("groupId")
  @ApiModelProperty(value = "The group Id of the job.")
  
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public Job projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The project Id associated with the job.
   * @return projectId
   **/
  @JsonProperty("projectId")
  @ApiModelProperty(value = "The project Id associated with the job.")
  
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public Job jobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
    return this;
  }

  /**
   * The id of the user who submitted the job.
   * @return jobOwner
   **/
  @JsonProperty("jobOwner")
  @ApiModelProperty(value = "The id of the user who submitted the job.")
  
  public String getJobOwner() {
    return jobOwner;
  }

  public void setJobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
  }

  public Job automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
    return this;
  }

  /**
   * If the user select a machine for execution or not.
   * @return automaticallyMachineSelection
   **/
  @JsonProperty("automaticallyMachineSelection")
  @ApiModelProperty(value = "If the user select a machine for execution or not.")
  
  public Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
  }

  public Job submissionMachines(List<String> submissionMachines) {
    this.submissionMachines = submissionMachines;
    return this;
  }

  public Job addSubmissionMachinesItem(String submissionMachinesItem) {
    if (this.submissionMachines == null) {
      this.submissionMachines = new ArrayList<>();
    }
    this.submissionMachines.add(submissionMachinesItem);
    return this;
  }

  /**
   * The selected machines for job execution. If the user choose the automatically machine selection, this information is empty.
   * @return submissionMachines
   **/
  @JsonProperty("submissionMachines")
  @ApiModelProperty(value = "The selected machines for job execution. If the user choose the automatically machine selection, this information is empty.")
  
  public List<String> getSubmissionMachines() {
    return submissionMachines;
  }

  public void setSubmissionMachines(List<String> submissionMachines) {
    this.submissionMachines = submissionMachines;
  }

  public Job numberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
    return this;
  }

  /**
   * The total number of job processes. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcesses
   **/
  @JsonProperty("numberOfProcesses")
  @ApiModelProperty(value = "The total number of job processes. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcesses() {
    return numberOfProcesses;
  }

  public void setNumberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
  }

  public Job numberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    return this;
  }

  /**
   * The number of job processes by machine. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcessesByMachine
   **/
  @JsonProperty("numberOfProcessesByMachine")
  @ApiModelProperty(value = "The number of job processes by machine. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcessesByMachine() {
    return numberOfProcessesByMachine;
  }

  public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
  }

  public Job submissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
    return this;
  }

  /**
   * The submission time.
   * @return submissionTime
   **/
  @JsonProperty("submissionTime")
  @ApiModelProperty(value = "The submission time.")
  
  public String getSubmissionTime() {
    return submissionTime;
  }

  public void setSubmissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
  }

  public Job description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description provided by the user at submission. It can be empty.
   * @return description
   **/
  @JsonProperty("description")
  @ApiModelProperty(value = "The description provided by the user at submission. It can be empty.")
  
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Job priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the job.
   * @return priority
   **/
  @JsonProperty("priority")
  @ApiModelProperty(value = "The priority of the job.")
  
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public Job multipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
    return this;
  }

  /**
   * If the user requested a multiple execution.
   * @return multipleExecution
   **/
  @JsonProperty("multipleExecution")
  @ApiModelProperty(value = "If the user requested a multiple execution.")
  
  public Boolean getMultipleExecution() {
    return multipleExecution;
  }

  public void setMultipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
  }

  public Job jobType(JobType jobType) {
    this.jobType = jobType;
    return this;
  }

  /**
   * Get jobType
   * @return jobType
   **/
  @JsonProperty("jobType")
  @ApiModelProperty(value = "")
  @Valid
  public JobType getJobType() {
    return jobType;
  }

  public void setJobType(JobType jobType) {
    this.jobType = jobType;
  }

  public Job numberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
    return this;
  }

  /**
   * The number of times the job has already been scheduled for execution.
   * @return numberOfAttempts
   **/
  @JsonProperty("numberOfAttempts")
  @ApiModelProperty(value = "The number of times the job has already been scheduled for execution.")
  
  public Integer getNumberOfAttempts() {
    return numberOfAttempts;
  }

  public void setNumberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
  }

  public Job executionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
    return this;
  }

  /**
   * The machine where the job executed (or was scheduled to execute).
   * @return executionMachine
   **/
  @JsonProperty("executionMachine")
  @ApiModelProperty(value = "The machine where the job executed (or was scheduled to execute).")
  
  public String getExecutionMachine() {
    return executionMachine;
  }

  public void setExecutionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
  }

  public Job endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The end time of the execution. It can be empty if the job have not already finished.
   * @return endTime
   **/
  @JsonProperty("endTime")
  @ApiModelProperty(value = "The end time of the execution. It can be empty if the job have not already finished.")
  
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public Job exitCode(Integer exitCode) {
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.
   * @return exitCode
   **/
  @JsonProperty("exitCode")
  @ApiModelProperty(value = "The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
  
  public Integer getExitCode() {
    return exitCode;
  }

  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }

  public Job guiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
    return this;
  }

  /**
   * The id of the algorithm of the flow that caused the job to finish earlier than expected.
   * @return guiltyNodeId
   **/
  @JsonProperty("guiltyNodeId")
  @ApiModelProperty(value = "The id of the algorithm of the flow that caused the job to finish earlier than expected.")
  
  public String getGuiltyNodeId() {
    return guiltyNodeId;
  }

  public void setGuiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
  }

  public Job exitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
    return this;
  }

  /**
   * Get exitStatus
   * @return exitStatus
   **/
  @JsonProperty("exitStatus")
  @ApiModelProperty(value = "")
  @Valid
  public ExitStatus getExitStatus() {
    return exitStatus;
  }

  public void setExitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
  }

  public Job cpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
    return this;
  }

  /**
   * Get cpuTime
   * @return cpuTime
   **/
  @JsonProperty("cpuTime")
  @ApiModelProperty(value = "")
  
  public Double getCpuTime() {
    return cpuTime;
  }

  public void setCpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
  }

  public Job wallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
    return this;
  }

  /**
   * Get wallclockTime
   * @return wallclockTime
   **/
  @JsonProperty("wallclockTime")
  @ApiModelProperty(value = "")
  
  public Integer getWallclockTime() {
    return wallclockTime;
  }

  public void setWallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
  }

  public Job ramMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
    return this;
  }

  /**
   * Get ramMemory
   * @return ramMemory
   **/
  @JsonProperty("ramMemory")
  @ApiModelProperty(value = "")
  
  public Double getRamMemory() {
    return ramMemory;
  }

  public void setRamMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
  }

  public Job statusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
    return this;
  }

  public Job addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
    if (this.statusHistory == null) {
      this.statusHistory = new ArrayList<>();
    }
    this.statusHistory.add(statusHistoryItem);
    return this;
  }

  /**
   * Get statusHistory
   * @return statusHistory
   **/
  @JsonProperty("statusHistory")
  @ApiModelProperty(value = "")
  @Valid
  public List<StatusChangeHistory> getStatusHistory() {
    return statusHistory;
  }

  public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
  }

  public Job algorithms(List<Algorithm> algorithms) {
    this.algorithms = algorithms;
    return this;
  }

  public Job addAlgorithmsItem(Algorithm algorithmsItem) {
    if (this.algorithms == null) {
      this.algorithms = new ArrayList<>();
    }
    this.algorithms.add(algorithmsItem);
    return this;
  }

  /**
   * Get algorithms
   * @return algorithms
   **/
  @JsonProperty("algorithms")
  @ApiModelProperty(value = "")
  @Valid
  public List<Algorithm> getAlgorithms() {
    return algorithms;
  }

  public void setAlgorithms(List<Algorithm> algorithms) {
    this.algorithms = algorithms;
  }

  public Job flowId(String flowId) {
    this.flowId = flowId;
    return this;
  }

  /**
   * The flow id associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowId
   **/
  @JsonProperty("flowId")
  @ApiModelProperty(value = "The flow id associated with the job (if jobType == FLOW).")
  
  public String getFlowId() {
    return flowId;
  }

  public void setFlowId(String flowId) {
    this.flowId = flowId;
  }

  public Job flowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
    return this;
  }

  /**
   * The flow version associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowVersion
   **/
  @JsonProperty("flowVersion")
  @ApiModelProperty(value = "The flow version associated with the job (if jobType == FLOW).")
  
  public String getFlowVersion() {
    return flowVersion;
  }

  public void setFlowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
  }

  public Job flowName(String flowName) {
    this.flowName = flowName;
    return this;
  }

  /**
   * The flow name associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowName
   **/
  @JsonProperty("flowName")
  @ApiModelProperty(value = "The flow name associated with the job (if jobType == FLOW).")
  
  public String getFlowName() {
    return flowName;
  }

  public void setFlowName(String flowName) {
    this.flowName = flowName;
  }

  public Job lastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The time of job last modification.
   * @return lastModifiedTime
   **/
  @JsonProperty("lastModifiedTime")
  @ApiModelProperty(value = "The time of job last modification.")
  
  public String getLastModifiedTime() {
    return lastModifiedTime;
  }

  public void setLastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Job job = (Job) o;
    return Objects.equals(this.jobId, job.jobId) &&
        Objects.equals(this.groupId, job.groupId) &&
        Objects.equals(this.projectId, job.projectId) &&
        Objects.equals(this.jobOwner, job.jobOwner) &&
        Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) &&
        Objects.equals(this.submissionMachines, job.submissionMachines) &&
        Objects.equals(this.numberOfProcesses, job.numberOfProcesses) &&
        Objects.equals(this.numberOfProcessesByMachine, job.numberOfProcessesByMachine) &&
        Objects.equals(this.submissionTime, job.submissionTime) &&
        Objects.equals(this.description, job.description) &&
        Objects.equals(this.priority, job.priority) &&
        Objects.equals(this.multipleExecution, job.multipleExecution) &&
        Objects.equals(this.jobType, job.jobType) &&
        Objects.equals(this.numberOfAttempts, job.numberOfAttempts) &&
        Objects.equals(this.executionMachine, job.executionMachine) &&
        Objects.equals(this.endTime, job.endTime) &&
        Objects.equals(this.exitCode, job.exitCode) &&
        Objects.equals(this.guiltyNodeId, job.guiltyNodeId) &&
        Objects.equals(this.exitStatus, job.exitStatus) &&
        Objects.equals(this.cpuTime, job.cpuTime) &&
        Objects.equals(this.wallclockTime, job.wallclockTime) &&
        Objects.equals(this.ramMemory, job.ramMemory) &&
        Objects.equals(this.statusHistory, job.statusHistory) &&
        Objects.equals(this.algorithms, job.algorithms) &&
        Objects.equals(this.flowId, job.flowId) &&
        Objects.equals(this.flowVersion, job.flowVersion) &&
        Objects.equals(this.flowName, job.flowName) &&
        Objects.equals(this.lastModifiedTime, job.lastModifiedTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobId, groupId, projectId, jobOwner, automaticallyMachineSelection, submissionMachines, numberOfProcesses, numberOfProcessesByMachine, submissionTime, description, priority, multipleExecution, jobType, numberOfAttempts, executionMachine, endTime, exitCode, guiltyNodeId, exitStatus, cpuTime, wallclockTime, ramMemory, statusHistory, algorithms, flowId, flowVersion, flowName, lastModifiedTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Job {\n");
    
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    jobOwner: ").append(toIndentedString(jobOwner)).append("\n");
    sb.append("    automaticallyMachineSelection: ").append(toIndentedString(automaticallyMachineSelection)).append("\n");
    sb.append("    submissionMachines: ").append(toIndentedString(submissionMachines)).append("\n");
    sb.append("    numberOfProcesses: ").append(toIndentedString(numberOfProcesses)).append("\n");
    sb.append("    numberOfProcessesByMachine: ").append(toIndentedString(numberOfProcessesByMachine)).append("\n");
    sb.append("    submissionTime: ").append(toIndentedString(submissionTime)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    multipleExecution: ").append(toIndentedString(multipleExecution)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    numberOfAttempts: ").append(toIndentedString(numberOfAttempts)).append("\n");
    sb.append("    executionMachine: ").append(toIndentedString(executionMachine)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    guiltyNodeId: ").append(toIndentedString(guiltyNodeId)).append("\n");
    sb.append("    exitStatus: ").append(toIndentedString(exitStatus)).append("\n");
    sb.append("    cpuTime: ").append(toIndentedString(cpuTime)).append("\n");
    sb.append("    wallclockTime: ").append(toIndentedString(wallclockTime)).append("\n");
    sb.append("    ramMemory: ").append(toIndentedString(ramMemory)).append("\n");
    sb.append("    statusHistory: ").append(toIndentedString(statusHistory)).append("\n");
    sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
    sb.append("    flowId: ").append(toIndentedString(flowId)).append("\n");
    sb.append("    flowVersion: ").append(toIndentedString(flowVersion)).append("\n");
    sb.append("    flowName: ").append(toIndentedString(flowName)).append("\n");
    sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

