/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.StatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;

public class JobView {
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="jobOwner")
    private String jobOwner;
    @JsonProperty(value="automaticallyMachineSelection")
    private Boolean automaticallyMachineSelection;
    @JsonProperty(value="selectedMachine")
    private String selectedMachine;
    @JsonProperty(value="numberOfProcesses")
    private Integer numberOfProcesses;
    @JsonProperty(value="numberOfProcessesByMachine")
    private Integer numberOfProcessesByMachine;
    @JsonProperty(value="submissionTime")
    private String submissionTime;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="priority")
    private Integer priority;
    @JsonProperty(value="multipleExecution")
    private Boolean multipleExecution;
    @JsonProperty(value="jobType")
    private JobType jobType = null;
    @JsonProperty(value="numberOfRetries")
    private Integer numberOfRetries;
    @JsonProperty(value="executionMachine")
    private String executionMachine;
    @JsonProperty(value="endTime")
    private String endTime;
    @JsonProperty(value="exitCode")
    private Integer exitCode;
    @JsonProperty(value="guiltyNodeId")
    private String guiltyNodeId;
    @JsonProperty(value="exitStatus")
    private ExitStatus exitStatus = null;
    @JsonProperty(value="cpuTime")
    private Double cpuTime;
    @JsonProperty(value="wallclockTime")
    private Integer wallclockTime;
    @JsonProperty(value="ramMemory")
    private Double ramMemory;
    @JsonProperty(value="flowId")
    private String flowId;
    @JsonProperty(value="flowVersion")
    private String flowVersion;
    @JsonProperty(value="flowName")
    private String flowName;
    @JsonProperty(value="lastModifiedTime")
    private String lastModifiedTime;
    @JsonProperty(value="jobStatus")
    private StatusType jobStatus = null;
    @JsonProperty(value="jobStatusTimestamp")
    private String jobStatusTimestamp;
    @JsonProperty(value="jaId")
    private Long jaId = null;
    @JsonProperty(value="algorithmId")
    private String algorithmId;
    @JsonProperty(value="algorithmVersion")
    private String algorithmVersion = null;
    @JsonProperty(value="algorithmName")
    private String algorithmName = null;
    @JsonProperty(value="jobAlgoParamId")
    private BigDecimal jobAlgoParamId;
    @JsonProperty(value="parameterId")
    private String parameterId = null;
    @JsonProperty(value="paramLabel")
    private String paramLabel = null;
    @JsonProperty(value="paramType")
    private String paramType = null;
    @JsonProperty(value="paramValue")
    private String paramValue = null;

    public JobView jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="jobId")
    @ApiModelProperty(value="The job Id.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public JobView groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @JsonProperty(value="groupId")
    @ApiModelProperty(value="The group Id of the job.")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public JobView projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @JsonProperty(value="projectId")
    @ApiModelProperty(value="The project Id associated with the job.")
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public JobView jobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
        return this;
    }

    @JsonProperty(value="jobOwner")
    @ApiModelProperty(value="The id of the user who submitted the job.")
    public String getJobOwner() {
        return this.jobOwner;
    }

    public void setJobOwner(String jobOwner) {
        this.jobOwner = jobOwner;
    }

    public JobView automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
        return this;
    }

    @JsonProperty(value="automaticallyMachineSelection")
    @ApiModelProperty(value="If the user select a machine for execution or not.")
    public Boolean getAutomaticallyMachineSelection() {
        return this.automaticallyMachineSelection;
    }

    public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
        this.automaticallyMachineSelection = automaticallyMachineSelection;
    }

    public JobView selectedMachine(String selectedMachine) {
        this.selectedMachine = selectedMachine;
        return this;
    }

    @JsonProperty(value="selectedMachine")
    @ApiModelProperty(value="The selected machines for job execution. If the user choose the automatically machine selection, this information is empty. (submissionMachines)")
    public String getSelectedMachine() {
        return this.selectedMachine;
    }

    public void setSelectedMachine(String selectedMachine) {
        this.selectedMachine = selectedMachine;
    }

    public JobView numberOfProcesses(Integer numberOfProcesses) {
        this.numberOfProcesses = numberOfProcesses;
        return this;
    }

    @JsonProperty(value="numberOfProcesses")
    @ApiModelProperty(value="The total number of job processes. In case of multiple execution, this number can be greater than one.")
    public Integer getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    public void setNumberOfProcesses(Integer numberOfProcesses) {
        this.numberOfProcesses = numberOfProcesses;
    }

    public JobView numberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
        this.numberOfProcessesByMachine = numberOfProcessesByMachine;
        return this;
    }

    @JsonProperty(value="numberOfProcessesByMachine")
    @ApiModelProperty(value="The number of job processes by machine. In case of multiple execution, this number can be greater than one.")
    public Integer getNumberOfProcessesByMachine() {
        return this.numberOfProcessesByMachine;
    }

    public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
        this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    }

    public JobView submissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
        return this;
    }

    @JsonProperty(value="submissionTime")
    @ApiModelProperty(value="The submission time.")
    public String getSubmissionTime() {
        return this.submissionTime;
    }

    public void setSubmissionTime(String submissionTime) {
        this.submissionTime = submissionTime;
    }

    public JobView description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @ApiModelProperty(value="The description provided by the user at submission. It can be empty.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JobView priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @JsonProperty(value="priority")
    @ApiModelProperty(value="The priority of the job.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public JobView multipleExecution(Boolean multipleExecution) {
        this.multipleExecution = multipleExecution;
        return this;
    }

    @JsonProperty(value="multipleExecution")
    @ApiModelProperty(value="If the user requested a multiple execution.")
    public Boolean getMultipleExecution() {
        return this.multipleExecution;
    }

    public void setMultipleExecution(Boolean multipleExecution) {
        this.multipleExecution = multipleExecution;
    }

    public JobView jobType(JobType jobType) {
        this.jobType = jobType;
        return this;
    }

    @JsonProperty(value="jobType")
    @ApiModelProperty(value="")
    @Valid
    public JobType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public JobView numberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    @JsonProperty(value="numberOfRetries")
    @ApiModelProperty(value="The number of times the job has already been scheduled for execution (numberOfAttempts).")
    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(Integer numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    public JobView executionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
        return this;
    }

    @JsonProperty(value="executionMachine")
    @ApiModelProperty(value="The machine where the job executed (or was scheduled to execute).")
    public String getExecutionMachine() {
        return this.executionMachine;
    }

    public void setExecutionMachine(String executionMachine) {
        this.executionMachine = executionMachine;
    }

    public JobView endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="endTime")
    @ApiModelProperty(value="The end time of the execution. It can be empty if the job have not already finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public JobView exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @JsonProperty(value="exitCode")
    @ApiModelProperty(value="The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public JobView guiltyNodeId(String guiltyNodeId) {
        this.guiltyNodeId = guiltyNodeId;
        return this;
    }

    @JsonProperty(value="guiltyNodeId")
    @ApiModelProperty(value="The id of the algorithm of the flow that caused the job to finish earlier than expected.")
    public String getGuiltyNodeId() {
        return this.guiltyNodeId;
    }

    public void setGuiltyNodeId(String guiltyNodeId) {
        this.guiltyNodeId = guiltyNodeId;
    }

    public JobView exitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
        return this;
    }

    @JsonProperty(value="exitStatus")
    @ApiModelProperty(value="")
    @Valid
    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public JobView cpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
        return this;
    }

    @JsonProperty(value="cpuTime")
    @ApiModelProperty(value="")
    public Double getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(Double cpuTime) {
        this.cpuTime = cpuTime;
    }

    public JobView wallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
        return this;
    }

    @JsonProperty(value="wallclockTime")
    @ApiModelProperty(value="")
    public Integer getWallclockTime() {
        return this.wallclockTime;
    }

    public void setWallclockTime(Integer wallclockTime) {
        this.wallclockTime = wallclockTime;
    }

    public JobView ramMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
        return this;
    }

    @JsonProperty(value="ramMemory")
    @ApiModelProperty(value="")
    public Double getRamMemory() {
        return this.ramMemory;
    }

    public void setRamMemory(Double ramMemory) {
        this.ramMemory = ramMemory;
    }

    public JobView flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @JsonProperty(value="flowId")
    @ApiModelProperty(value="The flow id associated with the job (if jobType == FLOW).")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public JobView flowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
        return this;
    }

    @JsonProperty(value="flowVersion")
    @ApiModelProperty(value="The flow version associated with the job (if jobType == FLOW).")
    public String getFlowVersion() {
        return this.flowVersion;
    }

    public void setFlowVersion(String flowVersion) {
        this.flowVersion = flowVersion;
    }

    public JobView flowName(String flowName) {
        this.flowName = flowName;
        return this;
    }

    @JsonProperty(value="flowName")
    @ApiModelProperty(value="The flow name associated with the job (if jobType == FLOW).")
    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    public JobView lastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    @JsonProperty(value="lastModifiedTime")
    @ApiModelProperty(value="The time of job last modification.")
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public JobView jobStatus(StatusType jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    @JsonProperty(value="jobStatus")
    @ApiModelProperty(value="")
    @Valid
    public StatusType getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(StatusType jobStatus) {
        this.jobStatus = jobStatus;
    }

    public JobView jobStatusTimestamp(String jobStatusTimestamp) {
        this.jobStatusTimestamp = jobStatusTimestamp;
        return this;
    }

    @JsonProperty(value="jobStatusTimestamp")
    @ApiModelProperty(value="")
    public String getJobStatusTimestamp() {
        return this.jobStatusTimestamp;
    }

    public void setJobStatusTimestamp(String jobStatusTimestamp) {
        this.jobStatusTimestamp = jobStatusTimestamp;
    }

    public JobView jaId(Long jaId) {
        this.jaId = jaId;
        return this;
    }

    @JsonProperty(value="jaId")
    @ApiModelProperty(value="Table id associated with the algorithm.")
    public Long getJaId() {
        return this.jaId;
    }

    public void setJaId(Long jaId) {
        this.jaId = jaId;
    }

    public JobView algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    @JsonProperty(value="algorithmId")
    @ApiModelProperty(value="The algorithm identification")
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public JobView algorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
        return this;
    }

    @JsonProperty(value="algorithmVersion")
    @ApiModelProperty(value="The algorithm version")
    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public JobView algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @JsonProperty(value="algorithmName")
    @ApiModelProperty(value="The algorithm name")
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public JobView jobAlgoParamId(BigDecimal jobAlgoParamId) {
        this.jobAlgoParamId = jobAlgoParamId;
        return this;
    }

    @JsonProperty(value="jobAlgoParamId")
    @ApiModelProperty(value="The job's algorithms parameter id.")
    @Valid
    public BigDecimal getJobAlgoParamId() {
        return this.jobAlgoParamId;
    }

    public void setJobAlgoParamId(BigDecimal jobAlgoParamId) {
        this.jobAlgoParamId = jobAlgoParamId;
    }

    public JobView parameterId(String parameterId) {
        this.parameterId = parameterId;
        return this;
    }

    @JsonProperty(value="parameterId")
    @ApiModelProperty(value="The parameter name")
    public String getParameterId() {
        return this.parameterId;
    }

    public void setParameterId(String parameterId) {
        this.parameterId = parameterId;
    }

    public JobView paramLabel(String paramLabel) {
        this.paramLabel = paramLabel;
        return this;
    }

    @JsonProperty(value="paramLabel")
    @ApiModelProperty(value="Parameter label")
    public String getParamLabel() {
        return this.paramLabel;
    }

    public void setParamLabel(String paramLabel) {
        this.paramLabel = paramLabel;
    }

    public JobView paramType(String paramType) {
        this.paramType = paramType;
        return this;
    }

    @JsonProperty(value="paramType")
    @ApiModelProperty(value="The type of the parameter")
    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public JobView paramValue(String paramValue) {
        this.paramValue = paramValue;
        return this;
    }

    @JsonProperty(value="paramValue")
    @ApiModelProperty(value="Job parameter value")
    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobView jobView = (JobView)o;
        return Objects.equals(this.jobId, jobView.jobId) && Objects.equals(this.groupId, jobView.groupId) && Objects.equals(this.projectId, jobView.projectId) && Objects.equals(this.jobOwner, jobView.jobOwner) && Objects.equals(this.automaticallyMachineSelection, jobView.automaticallyMachineSelection) && Objects.equals(this.selectedMachine, jobView.selectedMachine) && Objects.equals(this.numberOfProcesses, jobView.numberOfProcesses) && Objects.equals(this.numberOfProcessesByMachine, jobView.numberOfProcessesByMachine) && Objects.equals(this.submissionTime, jobView.submissionTime) && Objects.equals(this.description, jobView.description) && Objects.equals(this.priority, jobView.priority) && Objects.equals(this.multipleExecution, jobView.multipleExecution) && Objects.equals(this.jobType, jobView.jobType) && Objects.equals(this.numberOfRetries, jobView.numberOfRetries) && Objects.equals(this.executionMachine, jobView.executionMachine) && Objects.equals(this.endTime, jobView.endTime) && Objects.equals(this.exitCode, jobView.exitCode) && Objects.equals(this.guiltyNodeId, jobView.guiltyNodeId) && Objects.equals(this.exitStatus, jobView.exitStatus) && Objects.equals(this.cpuTime, jobView.cpuTime) && Objects.equals(this.wallclockTime, jobView.wallclockTime) && Objects.equals(this.ramMemory, jobView.ramMemory) && Objects.equals(this.flowId, jobView.flowId) && Objects.equals(this.flowVersion, jobView.flowVersion) && Objects.equals(this.flowName, jobView.flowName) && Objects.equals(this.lastModifiedTime, jobView.lastModifiedTime) && Objects.equals(this.jobStatus, jobView.jobStatus) && Objects.equals(this.jobStatusTimestamp, jobView.jobStatusTimestamp) && Objects.equals(this.jaId, jobView.jaId) && Objects.equals(this.algorithmId, jobView.algorithmId) && Objects.equals(this.algorithmVersion, jobView.algorithmVersion) && Objects.equals(this.algorithmName, jobView.algorithmName) && Objects.equals(this.jobAlgoParamId, jobView.jobAlgoParamId) && Objects.equals(this.parameterId, jobView.parameterId) && Objects.equals(this.paramLabel, jobView.paramLabel) && Objects.equals(this.paramType, jobView.paramType) && Objects.equals(this.paramValue, jobView.paramValue);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.groupId, this.projectId, this.jobOwner, this.automaticallyMachineSelection, this.selectedMachine, this.numberOfProcesses, this.numberOfProcessesByMachine, this.submissionTime, this.description, this.priority, this.multipleExecution, this.jobType, this.numberOfRetries, this.executionMachine, this.endTime, this.exitCode, this.guiltyNodeId, this.exitStatus, this.cpuTime, this.wallclockTime, this.ramMemory, this.flowId, this.flowVersion, this.flowName, this.lastModifiedTime, this.jobStatus, this.jobStatusTimestamp, this.jaId, this.algorithmId, this.algorithmVersion, this.algorithmName, this.jobAlgoParamId, this.parameterId, this.paramLabel, this.paramType, this.paramValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobView {\n");
        sb.append("    jobId: ").append(this.toIndentedString((Object)this.jobId)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString((Object)this.groupId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString((Object)this.projectId)).append("\n");
        sb.append("    jobOwner: ").append(this.toIndentedString((Object)this.jobOwner)).append("\n");
        sb.append("    automaticallyMachineSelection: ").append(this.toIndentedString((Object)this.automaticallyMachineSelection)).append("\n");
        sb.append("    selectedMachine: ").append(this.toIndentedString((Object)this.selectedMachine)).append("\n");
        sb.append("    numberOfProcesses: ").append(this.toIndentedString((Object)this.numberOfProcesses)).append("\n");
        sb.append("    numberOfProcessesByMachine: ").append(this.toIndentedString((Object)this.numberOfProcessesByMachine)).append("\n");
        sb.append("    submissionTime: ").append(this.toIndentedString((Object)this.submissionTime)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    multipleExecution: ").append(this.toIndentedString((Object)this.multipleExecution)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString((Object)this.jobType)).append("\n");
        sb.append("    numberOfRetries: ").append(this.toIndentedString((Object)this.numberOfRetries)).append("\n");
        sb.append("    executionMachine: ").append(this.toIndentedString((Object)this.executionMachine)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString((Object)this.endTime)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString((Object)this.exitCode)).append("\n");
        sb.append("    guiltyNodeId: ").append(this.toIndentedString((Object)this.guiltyNodeId)).append("\n");
        sb.append("    exitStatus: ").append(this.toIndentedString((Object)this.exitStatus)).append("\n");
        sb.append("    cpuTime: ").append(this.toIndentedString((Object)this.cpuTime)).append("\n");
        sb.append("    wallclockTime: ").append(this.toIndentedString((Object)this.wallclockTime)).append("\n");
        sb.append("    ramMemory: ").append(this.toIndentedString((Object)this.ramMemory)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString((Object)this.flowId)).append("\n");
        sb.append("    flowVersion: ").append(this.toIndentedString((Object)this.flowVersion)).append("\n");
        sb.append("    flowName: ").append(this.toIndentedString((Object)this.flowName)).append("\n");
        sb.append("    lastModifiedTime: ").append(this.toIndentedString((Object)this.lastModifiedTime)).append("\n");
        sb.append("    jobStatus: ").append(this.toIndentedString((Object)this.jobStatus)).append("\n");
        sb.append("    jobStatusTimestamp: ").append(this.toIndentedString((Object)this.jobStatusTimestamp)).append("\n");
        sb.append("    jaId: ").append(this.toIndentedString((Object)this.jaId)).append("\n");
        sb.append("    algorithmId: ").append(this.toIndentedString((Object)this.algorithmId)).append("\n");
        sb.append("    algorithmVersion: ").append(this.toIndentedString((Object)this.algorithmVersion)).append("\n");
        sb.append("    algorithmName: ").append(this.toIndentedString((Object)this.algorithmName)).append("\n");
        sb.append("    jobAlgoParamId: ").append(this.toIndentedString((Object)this.jobAlgoParamId)).append("\n");
        sb.append("    parameterId: ").append(this.toIndentedString((Object)this.parameterId)).append("\n");
        sb.append("    paramLabel: ").append(this.toIndentedString((Object)this.paramLabel)).append("\n");
        sb.append("    paramType: ").append(this.toIndentedString((Object)this.paramType)).append("\n");
        sb.append("    paramValue: ").append(this.toIndentedString((Object)this.paramValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

