/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.api.model.AlgorithmParameter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

public class Algorithm {
    @JsonProperty(value="algorithmId")
    private String algorithmId;
    @JsonProperty(value="algorithmVersion")
    private String algorithmVersion;
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @JsonProperty(value="flowNodeId")
    private Integer flowNodeId;
    @JsonProperty(value="parameters")
    private List<AlgorithmParameter> parameters = null;

    public Algorithm algorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
        return this;
    }

    @JsonProperty(value="algorithmId")
    @ApiModelProperty(value="The algorithm Id associated with the job.")
    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public Algorithm algorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
        return this;
    }

    @JsonProperty(value="algorithmVersion")
    @ApiModelProperty(value="The algoritm version associated with the job.")
    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public Algorithm algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @JsonProperty(value="algorithmName")
    @ApiModelProperty(value="The algoritm name associated with the job.")
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public Algorithm flowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    @JsonProperty(value="flowNodeId")
    @ApiModelProperty(value="The algorithm flow node id that helps to identify algorithms with same name and version when job is a flow.")
    public Integer getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Algorithm parameters(List<AlgorithmParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Algorithm addParametersItem(AlgorithmParameter parametersItem) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parametersItem);
        return this;
    }

    @JsonProperty(value="parameters")
    @ApiModelProperty(value="List with all algorithm parameters.")
    @Valid
    public List<AlgorithmParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<AlgorithmParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Algorithm algorithm = (Algorithm)o;
        return Objects.equals(this.algorithmId, algorithm.algorithmId) && Objects.equals(this.algorithmVersion, algorithm.algorithmVersion) && Objects.equals(this.algorithmName, algorithm.algorithmName) && Objects.equals(this.flowNodeId, algorithm.flowNodeId) && Objects.equals(this.parameters, algorithm.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.algorithmId, this.algorithmVersion, this.algorithmName, this.flowNodeId, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Algorithm {\n");
        sb.append("    algorithmId: ").append(this.toIndentedString((Object)this.algorithmId)).append("\n");
        sb.append("    algorithmVersion: ").append(this.toIndentedString((Object)this.algorithmVersion)).append("\n");
        sb.append("    algorithmName: ").append(this.toIndentedString((Object)this.algorithmName)).append("\n");
        sb.append("    flowNodeId: ").append(this.toIndentedString((Object)this.flowNodeId)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString((Object)this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

