package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.model.*;
import br.pucrio.tecgraf.soma.job.api.JobsApiService;
import br.pucrio.tecgraf.soma.job.api.factories.JobsApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;

import java.util.Map;
import java.util.List;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/jobs")


@io.swagger.annotations.Api(description = "the jobs API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2020-02-05T17:13:34.755Z[Etc/UTC]")
public class JobsApi  {
   private final JobsApiService delegate;

   public JobsApi(@Context ServletConfig servletContext) {
      JobsApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("JobsApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (JobsApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         } 
      }

      if (delegate == null) {
         delegate = JobsApiServiceFactory.getJobsApi();
      }

      this.delegate = delegate;
   }

    @DELETE
    @Path("/history")
    
    
    @io.swagger.annotations.ApiOperation(value = "Archive a job execution.", notes = "This endpoint archives the job execution, removing from the list of searchable jobs.", response = Void.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 204, message = "Successful operation.", response = Void.class),
        
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user is not authorized to archive the job. Only the job owner or the administrator can archive a job.", response = Void.class),
        
        @io.swagger.annotations.ApiResponse(code = 500, message = "Processing error occurred during the job archive operation.", response = Void.class) })
    public Response jobsHistoryDelete(@ApiParam(value = "The IDs of the jobs to be archived.",required=true, defaultValue="new ArrayList<>()") @DefaultValue("new ArrayList<>()") @QueryParam("jobIds") List<String> jobIds
,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale") String locale
,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryDelete(jobIds,locale,securityContext);
    }
    @GET
    @Path("/history")
    
    @Produces({ "application/json;", "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Fetch filtered list of jobs from view job_view.", notes = "This endpoint list all jobs that match the parameters criteria", response = JobResponse.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = JobResponse.class),
        
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user does not have permission to access the project.", response = Void.class),
        
        @io.swagger.annotations.ApiResponse(code = 400, message = "bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response = Error.class) })
    public Response jobsHistoryGet(@ApiParam(value = "The query in RSQL format.") @QueryParam("q") String q
,@ApiParam(value = "The zero based position of the first item to retrieve") @QueryParam("offset") Integer offset
,@ApiParam(value = "The number of items to retrieve") @QueryParam("limit") Integer limit
,@ApiParam(value = "Parameter indicating the sorting direction of the results") @QueryParam("asc") Boolean asc
,@ApiParam(value = "Attribute that should be used to sort the results") @QueryParam("attr") String attr
,@ApiParam(value = "Add algorithm's parameter values.", defaultValue="true") @DefaultValue("true") @QueryParam("showParam") Boolean showParam
,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale") String locale
,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsHistoryGet(q,offset,limit,asc,attr,showParam,locale,securityContext);
    }
}
