/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.JobsApiService;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.factories.JobsApiServiceFactory;
import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/jobs")
@Api(description="the jobs API")
public class JobsApi {
    private final JobsApiService delegate;

    public JobsApi(@Context ServletConfig servletContext) {
        String implClass;
        JobsApiService delegate = null;
        if (servletContext != null && (implClass = servletContext.getInitParameter("JobsApi.implementation")) != null && !"".equals(implClass.trim())) {
            try {
                delegate = (JobsApiService)Class.forName(implClass).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (delegate == null) {
            delegate = JobsApiServiceFactory.getJobsApi();
        }
        this.delegate = delegate;
    }

    @DELETE
    @Path(value="/history")
    @ApiOperation(value="Archive a job execution.", notes="This endpoint archives the job execution, removing from the list of searchable jobs.", response=Void.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation.", response=Void.class), @ApiResponse(code=403, message="if the authenticated user is not authorized to archive the job. Only the job owner or the administrator can archive a job.", response=Void.class), @ApiResponse(code=500, message="Processing error occurred during the job archive operation.", response=Void.class)})
    public Response jobsHistoryDelete(@ApiParam(value="The IDs of the jobs to be archived.", required=true, defaultValue="new ArrayList<>()") @DefaultValue(value="new ArrayList<>()") @QueryParam(value="jobIds") List<String> jobIds, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryDelete(jobIds, locale, securityContext);
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json;", "application/json"})
    @ApiOperation(value="Fetch filtered list of jobs from view job_view.", notes="This endpoint list all jobs that match the parameters criteria", response=JobResponse.class, tags={"Jobs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobResponse.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the project.", response=Void.class), @ApiResponse(code=400, message="bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response=Error.class)})
    public Response jobsHistoryGet(@ApiParam(value="The query in RSQL format.") @QueryParam(value="q") String q, @ApiParam(value="The zero based position of the first item to retrieve") @QueryParam(value="offset") Integer offset, @ApiParam(value="The number of items to retrieve") @QueryParam(value="limit") Integer limit, @ApiParam(value="Parameter indicating the sorting direction of the results") @QueryParam(value="asc") Boolean asc, @ApiParam(value="Attribute that should be used to sort the results") @QueryParam(value="attr") String attr, @ApiParam(value="Add algorithm's parameter values.", defaultValue="true") @DefaultValue(value="true") @QueryParam(value="showParam") Boolean showParam, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.jobsHistoryGet(q, offset, limit, asc, attr, showParam, locale, securityContext);
    }
}

