package br.pucrio.tecgraf.soma.job.application.appservice;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

import javax.ws.rs.ForbiddenException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.application.service.MultiflowService;
import br.pucrio.tecgraf.soma.job.application.service.ProjectService;
import br.pucrio.tecgraf.soma.job.application.service.ReplicaService;
import br.pucrio.tecgraf.soma.job.domain.model.Replica;

@Service
public class ReplicaAppService {

  @Autowired private ProjectService projectService;
  @Autowired private MultiflowService multiflowService;
  @Autowired private ReplicaService replicaService;

   /**
   * Persiste os dados de uma execução de uma réplica.
   *
   * @param replicaJobData dados da execução de uma réplica.
   * @return o id da réplica
   */
  @Transactional
  public Long createReplicaJob(ReplicaJob replicaJobData) {
    br.pucrio.tecgraf.soma.job.domain.model.Multiflow multiflow = multiflowService.findMultiflowById(replicaJobData.getMultiflowId());

    if (!projectService.hasPermission(multiflow.getProjectId())) {
      throw new ForbiddenException("User has no permission to add a Replica to this project");
    }

    Replica replica = replicaService.findReplicaBy(multiflow.getId(), replicaJobData.getLineNumber().intValue());
    if(replica == null) {
      replica = new Replica();
      replica.setMultiflow(multiflow);
      replica.setLineNumber(replicaJobData.getLineNumber());
      replicaService.createReplica(replica);
    }
    
    br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob replicaJob = new br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob();
    replicaJob.setJobStringId(replicaJobData.getJobId());
    replicaJob.setSubmissionTime(LocalDateTime.now(ZoneOffset.UTC));

    replica.addReplicaJob(replicaJob);
    replicaService.updateReplica(replica);
    return replica.getId();
  }

}
