package br.pucrio.tecgraf.soma.job.application.controller;

import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.CannotCreateTransactionException;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.ReplicaApi;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.application.appservice.ReplicaAppService;

@Component
public class ReplicaController extends ReplicaApi {
  private static final Logger LOG = Logger.getLogger(ReplicaController.class);

  @Autowired private HttpServletRequest request;
  @Autowired private ReplicaAppService replicaAppService;

  public ReplicaController() {
    super(null);
  }

  @Override
  public Response replicaPost(@NotNull @Valid ReplicaJob replicaJobData, String locale, SecurityContext securityContext)
      throws NotFoundException {

    String accessToken = request.getHeader(HttpHeaders.AUTHORIZATION);
    if (accessToken == null || accessToken.isEmpty()) {
      LOG.info("Empty or null token");
      return Response.status(HttpStatus.UNAUTHORIZED.value()).build();
    }
    try {
      replicaAppService.createReplicaJob(replicaJobData);
    } catch (ServiceUnavailableException | CannotCreateTransactionException e) { // Casos de falha de conexão com o BD
      String errorMsg = "Error creating a Replica: " + e.getMessage();
      LOG.info(errorMsg);
      return Response.status(HttpStatus.SERVICE_UNAVAILABLE.value()).entity(errorMsg).build();
    } catch (ForbiddenException e) { // Casos de falta de permissão no projeto
      String errorMsg = "Error creating a Replica: " + e.getMessage();
      LOG.info(errorMsg);
      return Response.status(HttpStatus.FORBIDDEN.value()).entity(errorMsg).build();
    } catch (NoResultException e) { // Multifluxo não encontrado
      String errorMsg = "Error creating a Replica. Multiflow not found: " + e.getMessage();
      LOG.info(errorMsg);
      return Response.status(HttpStatus.NOT_FOUND.value()).entity(errorMsg).build();
    } catch (Exception e) { // Demais erros
      String errorMsg = "Error creating a Replica: " + e.getMessage();
      LOG.info(errorMsg);
      return Response.status(HttpStatus.INTERNAL_SERVER_ERROR.value()).entity(errorMsg).build();
    }

    return Response.status(HttpStatus.CREATED.value()).build();
  }


}
