/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobAlgorithmRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobGroupValCount;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobByIdSpecification;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobsInListSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.RSQLSpecFactory;
import com.github.tennaito.rsql.misc.Mapper;
import com.github.tennaito.rsql.misc.SimpleMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobService {
    private static final Logger LOG = Logger.getLogger(JobService.class);
    private static final SimpleMapper mapper = new SimpleMapper(2);
    private final RSQLSpecFactory<Job> jobRsqlBuilder;
    private final RSQLSpecFactory<JobAlgorithm> jobAlgoRsqlBuilder;
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobAlgorithmRepository jobAlgorithmRepository;

    JobService(JobRepository jobRepository, JobAlgorithmRepository jobAlgorithmRepository) {
        this.jobRepository = jobRepository;
        this.jobAlgorithmRepository = jobAlgorithmRepository;
        this.jobRsqlBuilder = new RSQLSpecFactory(jobRepository.getEntityManager(), (Mapper)mapper);
        this.jobAlgoRsqlBuilder = new RSQLSpecFactory(jobAlgorithmRepository.getEntityManager(), (Mapper)mapper);
    }

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        LOG.info((Object)String.format("Querying distinct algorithms using the query: %s", rsqlQuery));
        JPASpecification query = this.jobAlgoRsqlBuilder.create(rsqlQuery);
        return this.jobAlgorithmRepository.findDistinct(query);
    }

    @Transactional
    public Job findJobByStringId(String jobId) {
        return (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
    }

    @Transactional
    public void editJobComment(String jobId, String newComment) {
        Job job = this.findJobByStringId(jobId);
        job.setDescription(newComment);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        Job job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        job.setDeleted(true);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        JobsInListSpecification spec = new JobsInListSpecification(jobIds);
        List jobs = this.jobRepository.find((JPASpecification)spec, new Sort[0]);
        for (Job job : jobs) {
            job.setDeleted(true);
            this.jobRepository.update((Object)job);
        }
    }

    private int adjustOffset(int offset, int limit, int total) {
        if (offset > 0 && offset >= total) {
            offset = total % limit == 0 ? total - limit : total - total % limit;
        }
        return offset;
    }

    private Sort[] toSortArray(String sortAttribute, boolean ascending) {
        if (sortAttribute == null) {
            return new Sort[0];
        }
        return new Sort[]{new Sort(sortAttribute, ascending)};
    }

    @Transactional
    public void findJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        LOG.info((Object)String.format("Querying jobs using the query: %s", rsqlQuery));
        JobPagination pagination = response.getPagination();
        JPASpecification query = this.jobRsqlBuilder.create(rsqlQuery);
        int total = Math.toIntExact(this.jobRepository.count(query));
        pagination.setTotal(Integer.valueOf(total));
        if (total == 0) {
            pagination.setOffset(Integer.valueOf(0));
            response.getData().setJobs(Collections.emptyList());
        } else {
            offset = this.adjustOffset(offset, limit, total);
            Sort[] sorting = this.toSortArray(sortAttribute, ascending);
            List jobIds = this.jobRepository.findJobIds(query, limit, offset, sorting);
            List domainJobList = this.jobRepository.getJobs((Collection)jobIds, sorting);
            pagination.setOffset(Integer.valueOf(offset));
            response.getData().setJobs(this.convertDomainJobListToApiJobList(domainJobList));
        }
    }

    @Transactional
    public void findGroupedJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        LOG.info((Object)String.format("Querying grouped jobs using the query: %s", rsqlQuery));
        JobPagination pagination = response.getPagination();
        JPASpecification query = this.jobRsqlBuilder.create(rsqlQuery);
        int total = Math.toIntExact(this.jobRepository.countGroups(query));
        pagination.setTotal(Integer.valueOf(total));
        if (total == 0) {
            pagination.setOffset(Integer.valueOf(0));
            response.getData().setJobs(Collections.emptyList());
        } else {
            offset = this.adjustOffset(offset, limit, total);
            Sort[] sorting = this.toSortArray(sortAttribute, ascending);
            List groups = this.jobRepository.findGroupedJobs(query, limit, offset, sorting);
            List<String> groupIds = new ArrayList(groups.size());
            HashMap<Long, Integer> jobId2Pos = new HashMap<Long, Integer>(groups.size());
            for (int pos = 0; pos < groups.size(); ++pos) {
                JobGroupValCount group = (JobGroupValCount)groups.get(pos);
                jobId2Pos.put(group.firstJobId, pos);
                groupIds.add(group.groupId);
            }
            groupIds = this.jobRepository.filterSingletons(groupIds);
            List jobList = this.jobRepository.getJobs(jobId2Pos.keySet(), new Sort[0]);
            br.pucrio.tecgraf.soma.job.api.model.Job[] apiJobs = new br.pucrio.tecgraf.soma.job.api.model.Job[groups.size()];
            for (Job job : jobList) {
                br.pucrio.tecgraf.soma.job.api.model.Job apiJob = this.convertDomainJobToApiJob(job);
                int i = (Integer)jobId2Pos.get(job.getId());
                apiJobs[i] = apiJob;
                if (!groupIds.contains(job.getGroupId())) continue;
                JobGroupValCount group = (JobGroupValCount)groups.get(i);
                apiJob.setIsGroup(Boolean.valueOf(true));
                apiJob.setJobId(JsonUndefined.STRING);
                apiJob.setEndTime(JsonUndefined.STRING);
                apiJob.setCpuTime(JsonUndefined.DOUBLE);
                apiJob.setWallclockTime(JsonUndefined.INTEGER);
                apiJob.setRamMemory(JsonUndefined.DOUBLE);
                apiJob.setAlgorithms(JsonUndefined.typedList());
                apiJob.setStatusHistory(JsonUndefined.typedList());
                apiJob.setSubmissionTime(group.submissionTime.toString());
                apiJob.setLastModifiedTime(group.lastModifiedTime.toString());
                if (group.projectId > 1L) {
                    apiJob.setProjectId(JsonUndefined.STRING);
                }
                if (group.jobOwner > 1L) {
                    apiJob.setJobOwner(JsonUndefined.STRING);
                }
                if (group.automaticallyMachineSelection > 1L) {
                    apiJob.setAutomaticallyMachineSelection(JsonUndefined.BOOLEAN);
                }
                if (group.numberOfProcesses > 1L) {
                    apiJob.setNumberOfProcesses(JsonUndefined.INTEGER);
                }
                if (group.numberOfProcessesByMachine > 1L) {
                    apiJob.setNumberOfProcessesByMachine(JsonUndefined.INTEGER);
                }
                if (group.description > 1L) {
                    apiJob.setDescription(JsonUndefined.STRING);
                }
                if (group.priority > 1L) {
                    apiJob.setPriority(JsonUndefined.INTEGER);
                }
                if (group.multipleExecution > 1L) {
                    apiJob.setMultipleExecution(JsonUndefined.BOOLEAN);
                }
                if (group.jobType > 1L) {
                    apiJob.setJobType(null);
                }
                if (group.executionMachine > 1L) {
                    apiJob.setExecutionMachine(JsonUndefined.STRING);
                }
                if (group.exitCode > 1L) {
                    apiJob.setExitCode(JsonUndefined.INTEGER);
                }
                if (group.guiltyNodeId > 1L) {
                    apiJob.setGuiltyNodeId(JsonUndefined.STRING);
                }
                if (group.exitStatus > 1L) {
                    apiJob.setExitStatus(null);
                }
                if (group.flowId > 1L) {
                    apiJob.setFlowId(JsonUndefined.STRING);
                }
                if (group.flowVersion > 1L) {
                    apiJob.setFlowVersion(JsonUndefined.STRING);
                }
                if (group.flowName <= 1L) continue;
                apiJob.setFlowName(JsonUndefined.STRING);
            }
            pagination.setOffset(Integer.valueOf(offset));
            response.getData().setJobs(Arrays.asList(apiJobs));
        }
    }

    private List<br.pucrio.tecgraf.soma.job.api.model.Job> convertDomainJobListToApiJobList(List<Job> domainJobList) {
        return Arrays.asList((Object[])DomainMapper.convert(domainJobList, br.pucrio.tecgraf.soma.job.api.model.Job[].class));
    }

    private br.pucrio.tecgraf.soma.job.api.model.Job convertDomainJobToApiJob(Job domainJob) {
        return (br.pucrio.tecgraf.soma.job.api.model.Job)DomainMapper.convert((Object)domainJob, br.pucrio.tecgraf.soma.job.api.model.Job.class);
    }

    static {
        HashMap<String, String> jobAttribAliases = new HashMap<String, String>(10);
        jobAttribAliases.put("jobStatus", "statusHistory.status");
        jobAttribAliases.put("jobStatusTimestamp", "statusHistory.timestamp");
        jobAttribAliases.put("algorithmId", "algorithms.algorithmId");
        jobAttribAliases.put("algorithmVersion", "algorithms.algorithmVersion");
        jobAttribAliases.put("algorithmName", "algorithms.algorithmName");
        jobAttribAliases.put("flowNodeId", "algorithms.flowNodeId");
        jobAttribAliases.put("parameterId", "algorithms.parameters.parameterId");
        jobAttribAliases.put("paramLabel", "algorithms.parameters.label");
        jobAttribAliases.put("paramType", "algorithms.parameters.type");
        jobAttribAliases.put("paramValue", "algorithms.parameters.value");
        mapper.addMapping(Job.class, jobAttribAliases);
        HashMap<String, String> jobJobAlgorithmAttribAliases = new HashMap<String, String>(3);
        jobJobAlgorithmAttribAliases.put("jobStatus", "job.statusHistory.status");
        jobJobAlgorithmAttribAliases.put("exitStatus", "job.exitStatus");
        jobJobAlgorithmAttribAliases.put("groupId", "job.groupId");
        mapper.addMapping(JobAlgorithm.class, jobJobAlgorithmAttribAliases);
    }
}

