package br.pucrio.tecgraf.soma.job.application.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.MultiflowRepository;

@Service
public class MultiflowService {
  @Autowired private MultiflowRepository multiflowRepository;

  @Transactional
  public Multiflow createMultiflow(Multiflow multiflow) {
    multiflowRepository.add(multiflow);
    return multiflowRepository.findById(multiflow.getId());
  }

  @Transactional
  public List<Multiflow> findMultiflowsByProjectId(String projectId) {
    return multiflowRepository.findMultiflowsByProjectId(projectId);
  }

  @Transactional
  public Multiflow findMultiflowById(Long multiflowId) {
    return multiflowRepository.findById(multiflowId);
  }

  @Transactional
  public Multiflow updateMultiflow(Multiflow multiflow) {
    multiflowRepository.update(multiflow);
    return multiflowRepository.findById(multiflow.getId());
  }
}
