/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import java.util.List;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobAppService {
    @Autowired
    JobService service;
    @Autowired
    private ServiceConfiguration config;

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        return this.service.findDistinctAlgorithms(rsqlQuery);
    }

    @Transactional
    public void editJobComment(String jobId, String newComment, List<String> userProjects) throws ForbiddenException {
        this.service.editJobComment(jobId, newComment, userProjects);
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        this.service.markJobAsDeleted(jobId);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        this.service.markJobsAsDeleted(jobIds);
    }

    @Transactional
    public Tuple<List<Job>, Integer> findJobs(String rsqlQuery, int offset, int limit, boolean ascending, String sortAttribute) {
        return this.service.findJobs(rsqlQuery, offset, limit, ascending, sortAttribute);
    }

    public List<String> getUserProjects(String locale, String accessToken) throws NotFoundException, ServiceUnavailableException {
        String serverBaseURL = this.config.getValue(Constants.Config.SERVER_BASE_URL.option.getLongName());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(serverBaseURL);
        Invocation.Builder requestBuilder = target.path("projects").path("permissions").queryParam("locale", new Object[]{locale}).request(new String[]{"application/json"}).header("Authorization", (Object)accessToken);
        try {
            Response response = requestBuilder.get();
            if (response.getStatus() != 200) {
                throw new NotFoundException(response.getStatus(), "Error while trying to retrieve user projects: " + response.getEntity());
            }
            return (List)response.readEntity((GenericType)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (ProcessingException e) {
            e.printStackTrace();
            throw new ServiceUnavailableException("Failed retrieving user projects");
        }
    }
}

