/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.Job;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JobController
extends JobsApi {
    @Autowired
    private JobAppService jobAppService;
    @Autowired
    private HttpServletRequest request;
    private static final int maxResultLimit = 1000;

    public JobController() {
        super(null);
    }

    public Response jobsHistoryAlgorithmsGet(String q, String locale, SecurityContext securityContext) throws NotFoundException, ServiceUnavailableException {
        AlgorithmResponse response = new AlgorithmResponse();
        response.setProcessingDate(Long.valueOf(System.currentTimeMillis()));
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        q = this.filterUserProjects(locale, accessToken, q);
        response.setAlgorithms(Arrays.asList((Object[])DomainMapper.convert((Object)this.jobAppService.findDistinctAlgorithms(q), Algorithm[].class)));
        return Response.ok().entity((Object)response).build();
    }

    public Response jobsHistoryJobIdCommentPut(String jobId, NewComment requestBody, String locale, SecurityContext securityContext) throws NotFoundException, ForbiddenException, ServiceUnavailableException {
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        if (requestBody == null || requestBody.getNewComment() == null) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Missing body with newComment parameter").build();
        }
        List userProjects = this.jobAppService.getUserProjects(locale, accessToken);
        this.jobAppService.editJobComment(jobId, requestBody.getNewComment(), userProjects);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryDelete(List<String> jobIds, String locale, SecurityContext securityContext) throws NotFoundException {
        this.jobAppService.markJobsAsDeleted(jobIds);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryGet(String q, Integer offset, Integer limit, Boolean asc, String attr, Boolean showParam, String locale, SecurityContext securityContext) throws NotFoundException, ServiceUnavailableException {
        String accessToken;
        if (limit == null) {
            limit = 1000;
        } else if (limit <= 0 || limit > 1000) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Invalid limit value").build();
        }
        if (offset == null) {
            offset = 0;
        } else if (offset < 0) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Offset must be a positive number or zero").build();
        }
        if (asc == null) {
            asc = false;
        }
        if ((accessToken = this.request.getHeader("Authorization")) == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        q = this.filterUserProjectsAndHandleDeleted(locale, accessToken, q);
        Tuple found = this.jobAppService.findJobs(q, offset.intValue(), limit.intValue(), asc.booleanValue(), attr);
        List<Object> jobList = Arrays.asList((Object[])DomainMapper.convert((Object)found.getFirst(), Job[].class));
        JobPagination pagination = this.buildPaginationInfo(((Integer)found.getSecond()).intValue(), offset.intValue(), limit.intValue());
        return this.responseJobs(jobList, pagination);
    }

    public String filterUserProjects(String locale, String accessToken, String q) throws NotFoundException, ServiceUnavailableException {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "job.projectId");
        q = q == null || q.length() == 0 ? projectsQuery : String.format("(%s);(%s)", q, projectsQuery);
        return q;
    }

    public String filterUserProjectsAndHandleDeleted(String locale, String accessToken, String q) throws NotFoundException, ServiceUnavailableException {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "projectId");
        String baseQuery = "isDeleted==false;" + projectsQuery;
        q = q == null || q.length() == 0 ? baseQuery : (!q.contains("isDeleted") ? String.format("(%s);(%s)", q, baseQuery) : String.format("(%s);(%s)", q, projectsQuery));
        return q;
    }

    public String getUserProjectsPredicate(String locale, String accessToken, String projectColumn) throws NotFoundException, ServiceUnavailableException {
        List projectIds = this.jobAppService.getUserProjects(locale, accessToken);
        if (projectIds.isEmpty()) {
            throw new NotFoundException(HttpStatus.NOT_FOUND.value(), "User has access to no projects");
        }
        StringBuilder projectsQuery = new StringBuilder(projectColumn);
        projectsQuery.append("=in=(");
        for (String projectId : projectIds) {
            projectsQuery.append(projectId);
            projectsQuery.append(",");
        }
        projectsQuery.deleteCharAt(projectsQuery.lastIndexOf(","));
        projectsQuery.append(")");
        return projectsQuery.toString();
    }

    private JobPagination buildPaginationInfo(int total, int offset, int limit) {
        JobPagination pagination = new JobPagination();
        pagination.total(Integer.valueOf(total));
        pagination.offset(Integer.valueOf(offset));
        pagination.limit(Integer.valueOf(limit));
        return pagination;
    }

    private Response responseJobs(List<Job> jobList, JobPagination pagination) {
        JobData data = new JobData();
        data.processingDate(Long.valueOf(System.currentTimeMillis()));
        data.jobs(jobList);
        JobResponse response = new JobResponse();
        response.data(data);
        response.pagination(pagination);
        return Response.ok().entity((Object)response).build();
    }
}

