/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobAlgorithmRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobByIdSpecification;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobsInListSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.RSQLSpecFactory;
import com.github.tennaito.rsql.misc.Mapper;
import com.github.tennaito.rsql.misc.SimpleMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.persistence.NoResultException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobService {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobAlgorithmRepository jobAlgorithmRepository;
    private final RSQLSpecFactory<Job> jobRsqlBuilder;
    private final RSQLSpecFactory<JobAlgorithm> jobAlgoRsqlBuilder;
    private static final SimpleMapper mapper = new SimpleMapper(1);

    JobService(JobRepository jobRepository, JobAlgorithmRepository jobAlgorithmRepository) {
        this.jobRepository = jobRepository;
        this.jobAlgorithmRepository = jobAlgorithmRepository;
        this.jobRsqlBuilder = new RSQLSpecFactory(jobRepository.getEntityManager(), (Mapper)mapper);
        this.jobAlgoRsqlBuilder = new RSQLSpecFactory(jobAlgorithmRepository.getEntityManager());
    }

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        JPASpecification query = this.jobAlgoRsqlBuilder.create(rsqlQuery);
        return this.jobAlgorithmRepository.findDistinct(query);
    }

    @Transactional
    public void editJobComment(String jobId, String newComment, List<String> userProjects) throws NotFoundException, ForbiddenException {
        Job job = null;
        try {
            job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        }
        catch (NoResultException e) {
            System.err.println("Job " + jobId + " not found!");
            e.printStackTrace();
        }
        if (job == null) {
            throw new NotFoundException("Job not found: " + jobId);
        }
        if (!userProjects.contains(job.getProjectId())) {
            throw new ForbiddenException("User has no permission to edit this job");
        }
        job.setDescription(newComment);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        Job job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        job.setDeleted(true);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        JobsInListSpecification spec = new JobsInListSpecification(jobIds);
        List jobs = this.jobRepository.find((JPASpecification)spec, new Sort[0]);
        for (Job job : jobs) {
            job.setDeleted(true);
            this.jobRepository.update((Object)job);
        }
    }

    private int adjustOffset(int offset, int limit, int total) {
        if (offset > 0 && offset >= total) {
            offset = total % limit == 0 ? total - limit : total - total % limit;
        }
        return offset;
    }

    private Sort[] toSortArray(String sortAttribute, boolean ascending) {
        if (sortAttribute == null) {
            return new Sort[0];
        }
        return new Sort[]{new Sort(sortAttribute, ascending)};
    }

    @Transactional
    public Tuple<List<Job>, Integer> findJobs(String rsqlQuery, int offset, int limit, boolean ascending, String sortAttribute) {
        JPASpecification query = this.jobRsqlBuilder.create(rsqlQuery);
        int total = Math.toIntExact(this.jobRepository.count(query));
        if (total == 0) {
            return new Tuple(Collections.emptyList(), (Object)0);
        }
        offset = this.adjustOffset(offset, limit, total);
        Sort[] sorting = this.toSortArray(sortAttribute, ascending);
        List jobIds = this.jobRepository.findJobIds(query, limit, offset, sorting);
        List jobList = this.jobRepository.getJobs(jobIds, sorting);
        return new Tuple((Object)jobList, (Object)total);
    }

    static {
        HashMap<String, String> jobAttribAliases = new HashMap<String, String>(10);
        jobAttribAliases.put("jobStatus", "statusHistory.status");
        jobAttribAliases.put("jobStatusTimestamp", "statusHistory.timestamp");
        jobAttribAliases.put("algorithmId", "algorithms.algorithmId");
        jobAttribAliases.put("algorithmVersion", "algorithms.algorithmVersion");
        jobAttribAliases.put("algorithmName", "algorithms.algorithmName");
        jobAttribAliases.put("flowNodeId", "algorithms.flowNodeId");
        jobAttribAliases.put("parameterId", "algorithms.parameters.parameterId");
        jobAttribAliases.put("paramLabel", "algorithms.parameters.label");
        jobAttribAliases.put("paramType", "algorithms.parameters.type");
        jobAttribAliases.put("paramValue", "algorithms.parameters.value");
        mapper.addMapping(Job.class, jobAttribAliases);
    }
}

