/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class JobRepository
extends JPARepository<Job> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<Job> getType() {
        return Job.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public List<Job> getJobs(List<Long> ids, Sort ... sorts) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Job.class);
        Root root = criteria.from(Job.class);
        criteria.where((Expression)root.get("id").in(ids)).orderBy(this.createSorting(builder, root, sorts));
        return manager.createQuery(criteria).getResultList();
    }

    public List<Long> findJobIds(JPASpecification<Job> specification, int maxResult, int offset, Sort ... sorts) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(Job.class);
        Predicate predicate = specification.toPredicate(root, builder);
        criteria.select((Selection)root.get("id")).where((Expression)predicate).orderBy(this.createSorting(builder, root, sorts));
        TypedQuery query = manager.createQuery(criteria);
        query.setMaxResults(maxResult);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query.getResultList();
    }

    private <T> List<Order> createSorting(CriteriaBuilder builder, Root<T> root, Sort ... sorts) {
        ArrayList<Order> sorting = new ArrayList<Order>();
        for (Sort sort : sorts) {
            if (sort.isAscending()) {
                sorting.add(builder.asc((Expression)root.get(sort.getAttribute())));
                continue;
            }
            sorting.add(builder.desc((Expression)root.get(sort.getAttribute())));
        }
        return sorting;
    }
}

