/*
 * Job History Service
 * Job History Search API
 *
 * The version of the OpenAPI document: 1.1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package br.pucrio.tecgraf.soma.job.api.model;

import java.util.Objects;
import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.StatusChangeHistory;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * Job
 */
@JsonPropertyOrder({
  Job.JSON_PROPERTY_JOB_ID,
  Job.JSON_PROPERTY_IS_GROUP,
  Job.JSON_PROPERTY_GROUP_ID,
  Job.JSON_PROPERTY_PROJECT_ID,
  Job.JSON_PROPERTY_JOB_OWNER,
  Job.JSON_PROPERTY_AUTOMATICALLY_MACHINE_SELECTION,
  Job.JSON_PROPERTY_SUBMISSION_MACHINES,
  Job.JSON_PROPERTY_NUMBER_OF_PROCESSES,
  Job.JSON_PROPERTY_NUMBER_OF_PROCESSES_BY_MACHINE,
  Job.JSON_PROPERTY_SUBMISSION_TIME,
  Job.JSON_PROPERTY_DESCRIPTION,
  Job.JSON_PROPERTY_PRIORITY,
  Job.JSON_PROPERTY_MULTIPLE_EXECUTION,
  Job.JSON_PROPERTY_JOB_TYPE,
  Job.JSON_PROPERTY_NUMBER_OF_ATTEMPTS,
  Job.JSON_PROPERTY_EXECUTION_MACHINE,
  Job.JSON_PROPERTY_END_TIME,
  Job.JSON_PROPERTY_EXIT_CODE,
  Job.JSON_PROPERTY_GUILTY_NODE_ID,
  Job.JSON_PROPERTY_EXIT_STATUS,
  Job.JSON_PROPERTY_CPU_TIME,
  Job.JSON_PROPERTY_WALLCLOCK_TIME,
  Job.JSON_PROPERTY_RAM_MEMORY,
  Job.JSON_PROPERTY_STATUS_HISTORY,
  Job.JSON_PROPERTY_ALGORITHMS,
  Job.JSON_PROPERTY_FLOW_ID,
  Job.JSON_PROPERTY_FLOW_VERSION,
  Job.JSON_PROPERTY_FLOW_NAME,
  Job.JSON_PROPERTY_LAST_MODIFIED_TIME
})
@com.fasterxml.jackson.annotation.JsonInclude(value=com.fasterxml.jackson.annotation.JsonInclude.Include.CUSTOM,valueFilter=br.pucrio.tecgraf.soma.job.application.JsonUndefined.class)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2021-02-12T13:49:48.186Z[Etc/UTC]")
public class Job   {
  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  @JsonProperty(JSON_PROPERTY_JOB_ID)
  private String jobId;

  public static final String JSON_PROPERTY_IS_GROUP = "isGroup";
  @JsonProperty(JSON_PROPERTY_IS_GROUP)
  private Boolean isGroup = false;

  public static final String JSON_PROPERTY_GROUP_ID = "groupId";
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  private String groupId;

  public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
  @JsonProperty(JSON_PROPERTY_PROJECT_ID)
  private String projectId;

  public static final String JSON_PROPERTY_JOB_OWNER = "jobOwner";
  @JsonProperty(JSON_PROPERTY_JOB_OWNER)
  private String jobOwner;

  public static final String JSON_PROPERTY_AUTOMATICALLY_MACHINE_SELECTION = "automaticallyMachineSelection";
  @JsonProperty(JSON_PROPERTY_AUTOMATICALLY_MACHINE_SELECTION)
  private Boolean automaticallyMachineSelection;

  public static final String JSON_PROPERTY_SUBMISSION_MACHINES = "submissionMachines";
  @JsonProperty(JSON_PROPERTY_SUBMISSION_MACHINES)
  private List<String> submissionMachines = null;

  public static final String JSON_PROPERTY_NUMBER_OF_PROCESSES = "numberOfProcesses";
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_PROCESSES)
  private Integer numberOfProcesses;

  public static final String JSON_PROPERTY_NUMBER_OF_PROCESSES_BY_MACHINE = "numberOfProcessesByMachine";
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_PROCESSES_BY_MACHINE)
  private Integer numberOfProcessesByMachine;

  public static final String JSON_PROPERTY_SUBMISSION_TIME = "submissionTime";
  @JsonProperty(JSON_PROPERTY_SUBMISSION_TIME)
  private String submissionTime;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  private String description;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  private Integer priority;

  public static final String JSON_PROPERTY_MULTIPLE_EXECUTION = "multipleExecution";
  @JsonProperty(JSON_PROPERTY_MULTIPLE_EXECUTION)
  private Boolean multipleExecution;

  public static final String JSON_PROPERTY_JOB_TYPE = "jobType";
  @JsonProperty(JSON_PROPERTY_JOB_TYPE)
  private JobType jobType;

  public static final String JSON_PROPERTY_NUMBER_OF_ATTEMPTS = "numberOfAttempts";
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ATTEMPTS)
  private Integer numberOfAttempts;

  public static final String JSON_PROPERTY_EXECUTION_MACHINE = "executionMachine";
  @JsonProperty(JSON_PROPERTY_EXECUTION_MACHINE)
  private String executionMachine;

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  @JsonProperty(JSON_PROPERTY_END_TIME)
  private String endTime;

  public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
  @JsonProperty(JSON_PROPERTY_EXIT_CODE)
  private Integer exitCode;

  public static final String JSON_PROPERTY_GUILTY_NODE_ID = "guiltyNodeId";
  @JsonProperty(JSON_PROPERTY_GUILTY_NODE_ID)
  private String guiltyNodeId;

  public static final String JSON_PROPERTY_EXIT_STATUS = "exitStatus";
  @JsonProperty(JSON_PROPERTY_EXIT_STATUS)
  private ExitStatus exitStatus;

  public static final String JSON_PROPERTY_CPU_TIME = "cpuTime";
  @JsonProperty(JSON_PROPERTY_CPU_TIME)
  private Double cpuTime;

  public static final String JSON_PROPERTY_WALLCLOCK_TIME = "wallclockTime";
  @JsonProperty(JSON_PROPERTY_WALLCLOCK_TIME)
  private Integer wallclockTime;

  public static final String JSON_PROPERTY_RAM_MEMORY = "ramMemory";
  @JsonProperty(JSON_PROPERTY_RAM_MEMORY)
  private Double ramMemory;

  public static final String JSON_PROPERTY_STATUS_HISTORY = "statusHistory";
  @JsonProperty(JSON_PROPERTY_STATUS_HISTORY)
  private List<StatusChangeHistory> statusHistory = null;

  public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
  @JsonProperty(JSON_PROPERTY_ALGORITHMS)
  private List<JobAlgorithm> algorithms = null;

  public static final String JSON_PROPERTY_FLOW_ID = "flowId";
  @JsonProperty(JSON_PROPERTY_FLOW_ID)
  private String flowId;

  public static final String JSON_PROPERTY_FLOW_VERSION = "flowVersion";
  @JsonProperty(JSON_PROPERTY_FLOW_VERSION)
  private String flowVersion;

  public static final String JSON_PROPERTY_FLOW_NAME = "flowName";
  @JsonProperty(JSON_PROPERTY_FLOW_NAME)
  private String flowName;

  public static final String JSON_PROPERTY_LAST_MODIFIED_TIME = "lastModifiedTime";
  @JsonProperty(JSON_PROPERTY_LAST_MODIFIED_TIME)
  private String lastModifiedTime;

  public Job jobId(String jobId) {
    this.jobId = jobId;
    return this;
  }

  /**
   * The job Id.
   * @return jobId
   **/
  @JsonProperty("jobId")
  @ApiModelProperty(value = "The job Id.")
  
  public String getJobId() {
    return jobId;
  }

  public void setJobId(String jobId) {
    this.jobId = jobId;
  }

  public Job isGroup(Boolean isGroup) {
    this.isGroup = isGroup;
    return this;
  }

  /**
   * If this entry describe a group of jobs instead of a single one.
   * @return isGroup
   **/
  @JsonProperty("isGroup")
  @ApiModelProperty(value = "If this entry describe a group of jobs instead of a single one.")
  
  public Boolean getIsGroup() {
    return isGroup;
  }

  public void setIsGroup(Boolean isGroup) {
    this.isGroup = isGroup;
  }

  public Job groupId(String groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * The group Id of the job.
   * @return groupId
   **/
  @JsonProperty("groupId")
  @ApiModelProperty(value = "The group Id of the job.")
  
  public String getGroupId() {
    return groupId;
  }

  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }

  public Job projectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The project Id associated with the job.
   * @return projectId
   **/
  @JsonProperty("projectId")
  @ApiModelProperty(value = "The project Id associated with the job.")
  
  public String getProjectId() {
    return projectId;
  }

  public void setProjectId(String projectId) {
    this.projectId = projectId;
  }

  public Job jobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
    return this;
  }

  /**
   * The id of the user who submitted the job.
   * @return jobOwner
   **/
  @JsonProperty("jobOwner")
  @ApiModelProperty(value = "The id of the user who submitted the job.")
  
  public String getJobOwner() {
    return jobOwner;
  }

  public void setJobOwner(String jobOwner) {
    this.jobOwner = jobOwner;
  }

  public Job automaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
    return this;
  }

  /**
   * If the user select a machine for execution or not.
   * @return automaticallyMachineSelection
   **/
  @JsonProperty("automaticallyMachineSelection")
  @ApiModelProperty(value = "If the user select a machine for execution or not.")
  
  public Boolean getAutomaticallyMachineSelection() {
    return automaticallyMachineSelection;
  }

  public void setAutomaticallyMachineSelection(Boolean automaticallyMachineSelection) {
    this.automaticallyMachineSelection = automaticallyMachineSelection;
  }

  public Job submissionMachines(List<String> submissionMachines) {
    this.submissionMachines = submissionMachines;
    return this;
  }

  public Job addSubmissionMachinesItem(String submissionMachinesItem) {
    if (this.submissionMachines == null) {
      this.submissionMachines = new ArrayList<>();
    }
    this.submissionMachines.add(submissionMachinesItem);
    return this;
  }

  /**
   * The selected machines for job execution. If the user choose the automatically machine selection, this information is empty.
   * @return submissionMachines
   **/
  @JsonProperty("submissionMachines")
  @ApiModelProperty(value = "The selected machines for job execution. If the user choose the automatically machine selection, this information is empty.")
  
  public List<String> getSubmissionMachines() {
    return submissionMachines;
  }

  public void setSubmissionMachines(List<String> submissionMachines) {
    this.submissionMachines = submissionMachines;
  }

  public Job numberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
    return this;
  }

  /**
   * The total number of job processes. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcesses
   **/
  @JsonProperty("numberOfProcesses")
  @ApiModelProperty(value = "The total number of job processes. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcesses() {
    return numberOfProcesses;
  }

  public void setNumberOfProcesses(Integer numberOfProcesses) {
    this.numberOfProcesses = numberOfProcesses;
  }

  public Job numberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
    return this;
  }

  /**
   * The number of job processes by machine. In case of multiple execution, this number can be greater than one.
   * @return numberOfProcessesByMachine
   **/
  @JsonProperty("numberOfProcessesByMachine")
  @ApiModelProperty(value = "The number of job processes by machine. In case of multiple execution, this number can be greater than one.")
  
  public Integer getNumberOfProcessesByMachine() {
    return numberOfProcessesByMachine;
  }

  public void setNumberOfProcessesByMachine(Integer numberOfProcessesByMachine) {
    this.numberOfProcessesByMachine = numberOfProcessesByMachine;
  }

  public Job submissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
    return this;
  }

  /**
   * The submission time.
   * @return submissionTime
   **/
  @JsonProperty("submissionTime")
  @ApiModelProperty(value = "The submission time.")
  
  public String getSubmissionTime() {
    return submissionTime;
  }

  public void setSubmissionTime(String submissionTime) {
    this.submissionTime = submissionTime;
  }

  public Job description(String description) {
    this.description = description;
    return this;
  }

  /**
   * The description provided by the user at submission. It can be empty.
   * @return description
   **/
  @JsonProperty("description")
  @ApiModelProperty(value = "The description provided by the user at submission. It can be empty.")
  
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Job priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the job.
   * @return priority
   **/
  @JsonProperty("priority")
  @ApiModelProperty(value = "The priority of the job.")
  
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }

  public Job multipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
    return this;
  }

  /**
   * If the user requested a multiple execution.
   * @return multipleExecution
   **/
  @JsonProperty("multipleExecution")
  @ApiModelProperty(value = "If the user requested a multiple execution.")
  
  public Boolean getMultipleExecution() {
    return multipleExecution;
  }

  public void setMultipleExecution(Boolean multipleExecution) {
    this.multipleExecution = multipleExecution;
  }

  public Job jobType(JobType jobType) {
    this.jobType = jobType;
    return this;
  }

  /**
   * Get jobType
   * @return jobType
   **/
  @JsonProperty("jobType")
  @ApiModelProperty(value = "")
  @Valid 
  public JobType getJobType() {
    return jobType;
  }

  public void setJobType(JobType jobType) {
    this.jobType = jobType;
  }

  public Job numberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
    return this;
  }

  /**
   * The number of times the job has already been scheduled for execution.
   * @return numberOfAttempts
   **/
  @JsonProperty("numberOfAttempts")
  @ApiModelProperty(value = "The number of times the job has already been scheduled for execution.")
  
  public Integer getNumberOfAttempts() {
    return numberOfAttempts;
  }

  public void setNumberOfAttempts(Integer numberOfAttempts) {
    this.numberOfAttempts = numberOfAttempts;
  }

  public Job executionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
    return this;
  }

  /**
   * The machine where the job executed (or was scheduled to execute).
   * @return executionMachine
   **/
  @JsonProperty("executionMachine")
  @ApiModelProperty(value = "The machine where the job executed (or was scheduled to execute).")
  
  public String getExecutionMachine() {
    return executionMachine;
  }

  public void setExecutionMachine(String executionMachine) {
    this.executionMachine = executionMachine;
  }

  public Job endTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * The end time of the execution. It can be empty if the job have not already finished.
   * @return endTime
   **/
  @JsonProperty("endTime")
  @ApiModelProperty(value = "The end time of the execution. It can be empty if the job have not already finished.")
  
  public String getEndTime() {
    return endTime;
  }

  public void setEndTime(String endTime) {
    this.endTime = endTime;
  }

  public Job exitCode(Integer exitCode) {
    this.exitCode = exitCode;
    return this;
  }

  /**
   * The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.
   * @return exitCode
   **/
  @JsonProperty("exitCode")
  @ApiModelProperty(value = "The code returned by the job execution. It can be empty if the job have not already finished or if the system could not gather it.")
  
  public Integer getExitCode() {
    return exitCode;
  }

  public void setExitCode(Integer exitCode) {
    this.exitCode = exitCode;
  }

  public Job guiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
    return this;
  }

  /**
   * The id of the algorithm of the flow that caused the job to finish earlier than expected.
   * @return guiltyNodeId
   **/
  @JsonProperty("guiltyNodeId")
  @ApiModelProperty(value = "The id of the algorithm of the flow that caused the job to finish earlier than expected.")
  
  public String getGuiltyNodeId() {
    return guiltyNodeId;
  }

  public void setGuiltyNodeId(String guiltyNodeId) {
    this.guiltyNodeId = guiltyNodeId;
  }

  public Job exitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
    return this;
  }

  /**
   * Get exitStatus
   * @return exitStatus
   **/
  @JsonProperty("exitStatus")
  @ApiModelProperty(value = "")
  @Valid 
  public ExitStatus getExitStatus() {
    return exitStatus;
  }

  public void setExitStatus(ExitStatus exitStatus) {
    this.exitStatus = exitStatus;
  }

  public Job cpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
    return this;
  }

  /**
   * Get cpuTime
   * @return cpuTime
   **/
  @JsonProperty("cpuTime")
  @ApiModelProperty(value = "")
  
  public Double getCpuTime() {
    return cpuTime;
  }

  public void setCpuTime(Double cpuTime) {
    this.cpuTime = cpuTime;
  }

  public Job wallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
    return this;
  }

  /**
   * Get wallclockTime
   * @return wallclockTime
   **/
  @JsonProperty("wallclockTime")
  @ApiModelProperty(value = "")
  
  public Integer getWallclockTime() {
    return wallclockTime;
  }

  public void setWallclockTime(Integer wallclockTime) {
    this.wallclockTime = wallclockTime;
  }

  public Job ramMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
    return this;
  }

  /**
   * Get ramMemory
   * @return ramMemory
   **/
  @JsonProperty("ramMemory")
  @ApiModelProperty(value = "")
  
  public Double getRamMemory() {
    return ramMemory;
  }

  public void setRamMemory(Double ramMemory) {
    this.ramMemory = ramMemory;
  }

  public Job statusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
    return this;
  }

  public Job addStatusHistoryItem(StatusChangeHistory statusHistoryItem) {
    if (this.statusHistory == null) {
      this.statusHistory = new ArrayList<>();
    }
    this.statusHistory.add(statusHistoryItem);
    return this;
  }

  /**
   * Get statusHistory
   * @return statusHistory
   **/
  @JsonProperty("statusHistory")
  @ApiModelProperty(value = "")
  @Valid 
  public List<StatusChangeHistory> getStatusHistory() {
    return statusHistory;
  }

  public void setStatusHistory(List<StatusChangeHistory> statusHistory) {
    this.statusHistory = statusHistory;
  }

  public Job algorithms(List<JobAlgorithm> algorithms) {
    this.algorithms = algorithms;
    return this;
  }

  public Job addAlgorithmsItem(JobAlgorithm algorithmsItem) {
    if (this.algorithms == null) {
      this.algorithms = new ArrayList<>();
    }
    this.algorithms.add(algorithmsItem);
    return this;
  }

  /**
   * Get algorithms
   * @return algorithms
   **/
  @JsonProperty("algorithms")
  @ApiModelProperty(value = "")
  @Valid 
  public List<JobAlgorithm> getAlgorithms() {
    return algorithms;
  }

  public void setAlgorithms(List<JobAlgorithm> algorithms) {
    this.algorithms = algorithms;
  }

  public Job flowId(String flowId) {
    this.flowId = flowId;
    return this;
  }

  /**
   * The flow id associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowId
   **/
  @JsonProperty("flowId")
  @ApiModelProperty(value = "The flow id associated with the job (if jobType == FLOW).")
  
  public String getFlowId() {
    return flowId;
  }

  public void setFlowId(String flowId) {
    this.flowId = flowId;
  }

  public Job flowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
    return this;
  }

  /**
   * The flow version associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowVersion
   **/
  @JsonProperty("flowVersion")
  @ApiModelProperty(value = "The flow version associated with the job (if jobType == FLOW).")
  
  public String getFlowVersion() {
    return flowVersion;
  }

  public void setFlowVersion(String flowVersion) {
    this.flowVersion = flowVersion;
  }

  public Job flowName(String flowName) {
    this.flowName = flowName;
    return this;
  }

  /**
   * The flow name associated with the job (if jobType &#x3D;&#x3D; FLOW).
   * @return flowName
   **/
  @JsonProperty("flowName")
  @ApiModelProperty(value = "The flow name associated with the job (if jobType == FLOW).")
  
  public String getFlowName() {
    return flowName;
  }

  public void setFlowName(String flowName) {
    this.flowName = flowName;
  }

  public Job lastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * The time of job last modification.
   * @return lastModifiedTime
   **/
  @JsonProperty("lastModifiedTime")
  @ApiModelProperty(value = "The time of job last modification.")
  
  public String getLastModifiedTime() {
    return lastModifiedTime;
  }

  public void setLastModifiedTime(String lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Job job = (Job) o;
    return Objects.equals(this.jobId, job.jobId) &&
        Objects.equals(this.isGroup, job.isGroup) &&
        Objects.equals(this.groupId, job.groupId) &&
        Objects.equals(this.projectId, job.projectId) &&
        Objects.equals(this.jobOwner, job.jobOwner) &&
        Objects.equals(this.automaticallyMachineSelection, job.automaticallyMachineSelection) &&
        Objects.equals(this.submissionMachines, job.submissionMachines) &&
        Objects.equals(this.numberOfProcesses, job.numberOfProcesses) &&
        Objects.equals(this.numberOfProcessesByMachine, job.numberOfProcessesByMachine) &&
        Objects.equals(this.submissionTime, job.submissionTime) &&
        Objects.equals(this.description, job.description) &&
        Objects.equals(this.priority, job.priority) &&
        Objects.equals(this.multipleExecution, job.multipleExecution) &&
        Objects.equals(this.jobType, job.jobType) &&
        Objects.equals(this.numberOfAttempts, job.numberOfAttempts) &&
        Objects.equals(this.executionMachine, job.executionMachine) &&
        Objects.equals(this.endTime, job.endTime) &&
        Objects.equals(this.exitCode, job.exitCode) &&
        Objects.equals(this.guiltyNodeId, job.guiltyNodeId) &&
        Objects.equals(this.exitStatus, job.exitStatus) &&
        Objects.equals(this.cpuTime, job.cpuTime) &&
        Objects.equals(this.wallclockTime, job.wallclockTime) &&
        Objects.equals(this.ramMemory, job.ramMemory) &&
        Objects.equals(this.statusHistory, job.statusHistory) &&
        Objects.equals(this.algorithms, job.algorithms) &&
        Objects.equals(this.flowId, job.flowId) &&
        Objects.equals(this.flowVersion, job.flowVersion) &&
        Objects.equals(this.flowName, job.flowName) &&
        Objects.equals(this.lastModifiedTime, job.lastModifiedTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobId, isGroup, groupId, projectId, jobOwner, automaticallyMachineSelection, submissionMachines, numberOfProcesses, numberOfProcessesByMachine, submissionTime, description, priority, multipleExecution, jobType, numberOfAttempts, executionMachine, endTime, exitCode, guiltyNodeId, exitStatus, cpuTime, wallclockTime, ramMemory, statusHistory, algorithms, flowId, flowVersion, flowName, lastModifiedTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Job {\n");
    
    sb.append("    jobId: ").append(toIndentedString(jobId)).append("\n");
    sb.append("    isGroup: ").append(toIndentedString(isGroup)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    jobOwner: ").append(toIndentedString(jobOwner)).append("\n");
    sb.append("    automaticallyMachineSelection: ").append(toIndentedString(automaticallyMachineSelection)).append("\n");
    sb.append("    submissionMachines: ").append(toIndentedString(submissionMachines)).append("\n");
    sb.append("    numberOfProcesses: ").append(toIndentedString(numberOfProcesses)).append("\n");
    sb.append("    numberOfProcessesByMachine: ").append(toIndentedString(numberOfProcessesByMachine)).append("\n");
    sb.append("    submissionTime: ").append(toIndentedString(submissionTime)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    multipleExecution: ").append(toIndentedString(multipleExecution)).append("\n");
    sb.append("    jobType: ").append(toIndentedString(jobType)).append("\n");
    sb.append("    numberOfAttempts: ").append(toIndentedString(numberOfAttempts)).append("\n");
    sb.append("    executionMachine: ").append(toIndentedString(executionMachine)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    exitCode: ").append(toIndentedString(exitCode)).append("\n");
    sb.append("    guiltyNodeId: ").append(toIndentedString(guiltyNodeId)).append("\n");
    sb.append("    exitStatus: ").append(toIndentedString(exitStatus)).append("\n");
    sb.append("    cpuTime: ").append(toIndentedString(cpuTime)).append("\n");
    sb.append("    wallclockTime: ").append(toIndentedString(wallclockTime)).append("\n");
    sb.append("    ramMemory: ").append(toIndentedString(ramMemory)).append("\n");
    sb.append("    statusHistory: ").append(toIndentedString(statusHistory)).append("\n");
    sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
    sb.append("    flowId: ").append(toIndentedString(flowId)).append("\n");
    sb.append("    flowVersion: ").append(toIndentedString(flowVersion)).append("\n");
    sb.append("    flowName: ").append(toIndentedString(flowName)).append("\n");
    sb.append("    lastModifiedTime: ").append(toIndentedString(lastModifiedTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

