/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class JobAppService {
    @Autowired
    private JobService service;
    @Autowired
    private ServiceConfiguration config;
    @Autowired
    private RestTemplate restTemplate;

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        return this.service.findDistinctAlgorithms(rsqlQuery);
    }

    @Transactional
    public void editJobComment(String jobId, String newComment, List<String> userProjects) throws ForbiddenException {
        this.service.editJobComment(jobId, newComment, userProjects);
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        this.service.markJobAsDeleted(jobId);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        this.service.markJobsAsDeleted(jobIds);
    }

    @Transactional
    public void findJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        this.service.findJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
    }

    @Transactional
    public void findGroupedJobs(String rsqlQuery, int limit, int offset, boolean ascending, String sortAttribute, JobResponse response) {
        this.service.findGroupedJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
    }

    public List<String> getUserProjects(String locale, String accessToken) throws ServiceUnavailableException {
        String uri = this.config.getValue(Constants.Config.SERVER_BASE_URL.option.getLongName());
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)uri).path("projects/permissions");
        if (locale != null) {
            builder.queryParam("locale", new Object[]{locale});
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        headers.set("Authorization", accessToken);
        try {
            ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String[].class, new Object[0]);
            return Arrays.asList((Object[])response.getBody());
        }
        catch (RestClientException e) {
            e.printStackTrace();
            throw new ServiceUnavailableException("Failed retrieving user projects");
        }
    }
}

