package br.pucrio.tecgraf.soma.job.application.filter;

import org.jboss.logging.Logger;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

@Component
@Order(2)
public class RequestLogFilter implements Filter {
  private static final Logger LOG = Logger.getLogger(RequestLogFilter.class);

  @Override
  public void doFilter(
      ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain)
      throws IOException, ServletException {

    HttpServletRequest req = (HttpServletRequest) servletRequest;
    HttpServletResponse res = (HttpServletResponse) servletResponse;

    LOG.info(String.format("Received request  %s : %s", req.getMethod(), req.getRequestURI()));

    StringBuilder sb = new StringBuilder();
    sb.append("Request parameters: {");
    Iterator<Map.Entry<String, String[]>> it = req.getParameterMap().entrySet().iterator();
    while (it.hasNext()) {
      Map.Entry<String, String[]> parameter = it.next();
      sb.append(parameter.getKey()).append("=");
      String[] values = parameter.getValue();
      if (values.length == 0) {
        sb.append("null");
      } else if (values.length == 1) {
        sb.append(values[0]);
      } else {
        sb.append(Arrays.toString(values));
      }
      if (it.hasNext()) {
        sb.append(", ");
      }
    }
    sb.append("}");
    LOG.debug(sb.toString());

    filterChain.doFilter(servletRequest, servletResponse);
    LOG.info("Sending response");
  }
}
