package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.Multiflow;
import br.pucrio.tecgraf.soma.job.domain.model.MultiflowReplicaFile;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;

@Transactional
@Repository
public class MultiflowRepository extends JPARepository<Multiflow> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<Multiflow> getType() {
        return Multiflow.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public Multiflow findById(Long multiflowId) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<Multiflow> criteria = builder.createQuery(Multiflow.class);
        Root<Multiflow> root = criteria.from(Multiflow.class);
        criteria.where(builder.equal(root.get("id"),(multiflowId)));
        return manager.createQuery(criteria).getSingleResult();
    }

    public List<Multiflow> findMultiflowsByProjectId(String projectId) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<Multiflow> criteria = builder.createQuery(Multiflow.class);
        Root<Multiflow> root = criteria.from(Multiflow.class);

        criteria.select(root);
        // Precisa usar coalesce pois o Multiflow precisa ser encontrada mesmo se não tiver nenhum ReplicaFile associado
        criteria.where(builder.and(
            builder.equal(builder.coalesce(root.get("isDeleted"), false), false),
            builder.equal(root.get("projectId"), projectId)
        ));
        return manager.createQuery(criteria).getResultList();
    }

}
