package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.ReplicaFile;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;

@Transactional
@Repository
public class ReplicaFileRepository extends JPARepository<ReplicaFile> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<ReplicaFile> getType() {
        return ReplicaFile.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

}
