/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"algorithms", "processingDate"})
@JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonUndefined.class)
public class AlgorithmResponse {
    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    @JsonProperty(value="algorithms")
    private List<@Valid Algorithm> algorithms = new ArrayList();
    public static final String JSON_PROPERTY_PROCESSING_DATE = "processingDate";
    @JsonProperty(value="processingDate")
    private Long processingDate;

    public AlgorithmResponse algorithms(List<@Valid Algorithm> algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    public AlgorithmResponse addAlgorithmsItem(Algorithm algorithmsItem) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList();
        }
        this.algorithms.add(algorithmsItem);
        return this;
    }

    @JsonProperty(value="algorithms")
    @ApiModelProperty(value="Distinct algorithms used by the filtered jobs.")
    @Valid
    public @Valid List<@Valid Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<@Valid Algorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public AlgorithmResponse processingDate(Long processingDate) {
        this.processingDate = processingDate;
        return this;
    }

    @JsonProperty(value="processingDate")
    @ApiModelProperty(value="Timestamp when the data were collected")
    public Long getProcessingDate() {
        return this.processingDate;
    }

    public void setProcessingDate(Long processingDate) {
        this.processingDate = processingDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmResponse algorithmResponse = (AlgorithmResponse)o;
        return Objects.equals(this.algorithms, algorithmResponse.algorithms) && Objects.equals(this.processingDate, algorithmResponse.processingDate);
    }

    public int hashCode() {
        return Objects.hash(this.algorithms, this.processingDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmResponse {\n");
        sb.append("    algorithms: ").append(this.toIndentedString((Object)this.algorithms)).append("\n");
        sb.append("    processingDate: ").append(this.toIndentedString((Object)this.processingDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

