/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.configuration;

import br.pucrio.tecgraf.soma.job.application.configuration.Constants;
import br.pucrio.tecgraf.soma.serviceapi.ServiceContext;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import jakarta.persistence.EntityManagerFactory;
import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@Profile(value={"production"})
@EnableCaching
public class SomaJobHistoryConfiguration {
    private final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConfiguration.class);

    @Bean
    public ServiceContext serviceContext(ServiceConfiguration serviceConfiguration) {
        try {
            String hibernateConfiguration = serviceConfiguration.getValue(Constants.Config.HIBERNATE_CONFIGURATION.option.getLongName());
            Properties properties = null;
            if (hibernateConfiguration != null) {
                properties = new Properties();
                properties.load(new StringReader(hibernateConfiguration.replaceAll(",", "\n")));
            }
            return new ServiceContext(properties, "hibernate.cfg.xml", new String[]{"br.pucrio.tecgraf.soma.job.domain.model"});
        }
        catch (Exception ex) {
            this.logger.error("Error building service context.", (Throwable)ex);
            return null;
        }
    }

    @Bean
    public EntityManagerFactory entityManagerFactory(ServiceContext serviceContext) {
        return serviceContext.getEntityManagerFactory();
    }

    @Bean
    public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(emf);
        return transactionManager;
    }

    @Bean
    public ServiceConfiguration serviceConfiguration(ApplicationArguments appArgs) {
        try {
            return ServiceConfiguration.build((List)Constants.Config.options(), (String[])appArgs.getSourceArgs(), (boolean)true);
        }
        catch (ParseException e) {
            this.logger.error("Error parsing command line arguments", (Throwable)e);
            throw new Error("Unrecoverable error parsing command line arguments.");
        }
    }
}

