/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.ReplicaApi;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJob;
import br.pucrio.tecgraf.soma.job.api.model.ReplicaJobResponse;
import br.pucrio.tecgraf.soma.job.application.appservice.ReplicaAppService;
import jakarta.persistence.NoResultException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class ReplicaController
extends ReplicaApi {
    private static final Logger LOG = Logger.getLogger(ReplicaController.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private ReplicaAppService replicaAppService;

    public ReplicaController() {
        super(null);
    }

    public Response replicaPost(@NotNull @Valid ReplicaJob replicaJobData, String locale, SecurityContext securityContext) throws NotFoundException {
        ReplicaJobResponse replicaJobResponse;
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        try {
            replicaJobResponse = this.replicaAppService.createReplicaJob(replicaJobData);
        }
        catch (ServiceUnavailableException | CannotCreateTransactionException e) {
            String errorMsg = "Database connection error creating a Replica: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.SERVICE_UNAVAILABLE.value()).entity((Object)errorMsg).build();
        }
        catch (ForbiddenException e) {
            String errorMsg = "Permission error creating a Replica: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.FORBIDDEN.value()).entity((Object)errorMsg).build();
        }
        catch (NoResultException e) {
            String errorMsg = "Error creating a Replica. Multiflow not found: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.NOT_FOUND.value()).entity((Object)errorMsg).build();
        }
        catch (HttpClientErrorException e) {
            String errorMsg = "HTTP error creating a Replica. " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)e.getStatusCode().value()).entity((Object)e.getStatusText()).build();
        }
        catch (Exception e) {
            String errorMsg = "Unknown error creating a Replica: " + e.getMessage();
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.INTERNAL_SERVER_ERROR.value()).entity((Object)errorMsg).build();
        }
        return Response.status((int)HttpStatus.CREATED.value()).entity((Object)replicaJobResponse).build();
    }
}

