package br.pucrio.tecgraf.soma.job.application.configuration;

import java.io.StringReader;
import java.util.Properties;
import jakarta.persistence.EntityManagerFactory;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants.Config;
import br.pucrio.tecgraf.soma.serviceapi.ServiceContext;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import org.springframework.cache.annotation.EnableCaching;

@Configuration
@Profile("production")
@EnableCaching
public class SomaJobHistoryConfiguration {

  private final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConfiguration.class);

  @Bean
  public ServiceContext serviceContext(ServiceConfiguration serviceConfiguration) {
    try {
      String hibernateConfiguration =
          serviceConfiguration.getValue(Config.HIBERNATE_CONFIGURATION.option.getLongName());
      Properties properties = null;
      if (hibernateConfiguration != null) {
        properties = new Properties();
        properties.load(new StringReader(hibernateConfiguration.replaceAll(",", "\n")));
      }
      return new ServiceContext(properties, "hibernate.cfg.xml",
          "br.pucrio.tecgraf.soma.job.domain.model");
    } catch (Exception ex) {
      logger.error("Error building service context.", ex);
    }
    return null;
  }

  @Bean
  public EntityManagerFactory entityManagerFactory(ServiceContext serviceContext) {
    return serviceContext.getEntityManagerFactory();
  }

  @Bean
  public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
    JpaTransactionManager transactionManager = new JpaTransactionManager();
    transactionManager.setEntityManagerFactory(emf);

    return transactionManager;
  }

  @Bean
  public ServiceConfiguration serviceConfiguration(ApplicationArguments appArgs) {
    try {
      return ServiceConfiguration.build(Config.options(), appArgs.getSourceArgs(), true);
    } catch (ParseException e) {
      logger.error("Error parsing command line arguments", e);
    }
    throw new Error("Unrecoverable error parsing command line arguments.");
  }

}
