/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.api;

import br.pucrio.tecgraf.soma.logservice.api.model.Error;
import br.pucrio.tecgraf.soma.logservice.api.model.JobLogResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/jobs/{jobId}/{flowNodeId}/logs")
@Api(description="the jobs API")
public interface JobsApi {
    @GET
    @Path(value="/download")
    @Produces(value={"application/octet-stream", "application/json"})
    @ApiOperation(value="Fetch the contents of a log file of a job.", notes="This endpoint provides access to the contents of a job's log file.", tags={"logs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=File.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the job's log file.", response=Void.class), @ApiResponse(code=400, message="bad parameters. The error code are: <br> 3. If a invalid base64 string was used in log file name 4. If a null or invalid base64 string was used in project ID 5. If a invalid base64 string was used in job ID. 6. If a null or invalid token was used. ", response=Error.class)})
    public Response jobsJobIdFlowNodeIdLogsDownloadGet(@PathParam(value="jobId") @ApiParam(value="The ID of the job encoded in base64.") String var1, @PathParam(value="flowNodeId") @Min(value=0L) @ApiParam(value="The ID of the flow node.") @Min(value=0L) Integer var2, @QueryParam(value="projectId") @NotNull @ApiParam(value="The ID of a project encoded in base64.") String var3, @QueryParam(value="token") @NotNull @ApiParam(value="The token check download permission to the file") String var4, @QueryParam(value="logName") @ApiParam(value="The log file name encoded in base64.") String var5);

    @GET
    @Produces(value={"application/json;", "application/json"})
    @ApiOperation(value="Fetch the contents of a log file of a job.", notes="This endpoint provides access to the contents of a job's log file.", tags={"logs"})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation.", response=JobLogResponse.class), @ApiResponse(code=403, message="if the authenticated user does not have permission to access the job's log file.", response=Void.class), @ApiResponse(code=400, message="bad parameters. The error code are: <br> 1. If a invalid offset was used 2. If a invalid length was used 3. If a invalid base64 string was used in log file name 4. If a null or invalid base64 string was used in project ID 5. If a invalid base64 string was used in job ID. 6. If a null or invalid token was used. ", response=Error.class)})
    public Response jobsJobIdFlowNodeIdLogsGet(@PathParam(value="jobId") @ApiParam(value="The ID of the job encoded in base64.") String var1, @PathParam(value="flowNodeId") @Min(value=0L) @ApiParam(value="The ID of the flow node.") @Min(value=0L) Integer var2, @QueryParam(value="projectId") @NotNull @ApiParam(value="The ID of a project encoded in base64.") String var3, @QueryParam(value="logName") @ApiParam(value="The log file name encoded in base64.") String var4, @QueryParam(value="encoding") @ApiParam(value="The charset encoding standard that will be used to open the file. Note -&gt; In case the giving encoding is not supported or is invalid, the default charset will be used. Supported charset encoding standards -&gt; [&#39;UTF-8&#39;, &#39;US-ASCII&#39;, &#39;ISO-8859-1&#39;]") String var5, @QueryParam(value="offset") @ApiParam(value="Zero-based index of the position of the file to start reading. 0 starts reading from the first byte of the file. When this offset is negative it indicates the number of bytes from the end of the file, thus -1 is the last byte in the file. Default is the negative value of parameter &#39;length&#39;, thus it reads the last &#39;length&#39; bytes of the log file.") Long var6, @QueryParam(value="length") @ApiParam(value="Maximum number of bytes to read from the log (default is 8192).") Integer var7, @QueryParam(value="chunkLength") @ApiParam(value="Length used to break the log content. For example if the requested length is 100 bytes and this parameter is 10 bytes, the content will be broken into 10 chunks, each one containing around 10 bytes. If this parameter is not provided, the result must contain a single chunk with all the obtained data. ") Integer var8);
}

