/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.filter;

import br.pucrio.tecgraf.soma.logservice.service.ProjectPermissionsService;
import br.pucrio.tecgraf.soma.logservice.utils.ResponseBuilder;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.jboss.logging.Logger;

@Priority(value=2000)
@Provider
public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger LOG = Logger.getLogger(AuthFilter.class);
    @Context
    UriInfo info;
    @Inject
    @RestClient
    ProjectPermissionsService projectPermissionsService;
    @ConfigProperty(name="application.project.permission.check.enable")
    public boolean projectPermissionCheckEnabled;

    public void filter(ContainerRequestContext context) {
        String token = this.getAuthToken(context);
        if (StringUtils.isEmpty((CharSequence)token)) {
            LOG.infof("Invalid or missing token", new Object[0]);
            context.abortWith(ResponseBuilder.buildBadRequestResponse(6));
            return;
        }
        this.addAuthTokenToHeader(context, token);
        List queryParamList = (List)this.info.getQueryParameters().get((Object)"projectId");
        if (CollectionUtils.isEmpty((Collection)queryParamList)) {
            LOG.infof("Mandatory projectId query parameter is missing", new Object[0]);
            context.abortWith(ResponseBuilder.buildBadRequestResponse(4));
        } else {
            String projectIdInBase64 = (String)queryParamList.get(0);
            if (!StringUtils.isEmpty((CharSequence)projectIdInBase64)) {
                String projectId;
                try {
                    projectId = new String(Base64.getUrlDecoder().decode(projectIdInBase64));
                }
                catch (IllegalArgumentException e) {
                    LOG.infof("Mandatory projectId query parameter is not in base64", new Object[0]);
                    context.abortWith(ResponseBuilder.buildBadRequestResponse(4));
                    return;
                }
                if (!this.checkProjectPermission(projectId).booleanValue()) {
                    LOG.warnf("User not allowed to project %s", (Object)projectId);
                    context.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
                    return;
                }
            } else {
                LOG.infof("Mandatory projectId query parameter is missing", new Object[0]);
                context.abortWith(ResponseBuilder.buildBadRequestResponse(4));
                return;
            }
        }
    }

    private Boolean checkProjectPermission(String projectId) {
        if (this.projectPermissionCheckEnabled) {
            LOG.infof("Checking user permission to project %s", (Object)projectId);
            List<String> projectPermissions = this.projectPermissionsService.getProjectPermissions();
            return projectPermissions.contains(projectId);
        }
        LOG.infof("Skipping user permission check to project %s", (Object)projectId);
        return true;
    }

    private String getAuthToken(ContainerRequestContext context) {
        List queryParamList = (List)this.info.getQueryParameters().get((Object)"token");
        if (CollectionUtils.isEmpty((Collection)queryParamList)) {
            return context.getHeaderString("Authorization");
        }
        return (String)queryParamList.get(0);
    }

    private void addAuthTokenToHeader(ContainerRequestContext context, String token) {
        if (!context.getHeaders().containsKey((Object)"Authorization")) {
            context.getHeaders().add((Object)"Authorization", (Object)("Bearer " + token));
        }
    }
}

