/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.application.service;

import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import br.pucrio.tecgraf.soma.websocketnotifier.application.appservice.EventAppService;
import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.Constants;
import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;
import br.pucrio.tecgraf.soma.websocketnotifier.application.service.ProducerHandler;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.AbstractChain;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.ChainException;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.EmptyChain;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.HandlerResult;
import br.pucrio.tecgraf.soma.websocketnotifier.model.WebsocketNotifierInfo;
import br.pucrio.tecgraf.soma.websocketnotifier.model.WebsocketNotifierStatus;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class SocketHandler
extends TextWebSocketHandler {
    private final Logger logger = LoggerFactory.getLogger(SocketHandler.class);
    private Map<String, AbstractChain> chainMap;
    @Autowired
    ServiceConfiguration serviceConfiguration;
    @Autowired
    private EventAppService eventAppService;
    @Autowired
    private ProducerHandler notificationProducer;
    private List<SomaWebSocketSession> sessions = new CopyOnWriteArrayList();

    public SocketHandler() {
    }

    @Autowired
    public SocketHandler(ProducerHandler notificationProducer, EventAppService eventAppService, ServiceConfiguration serviceConfiguration) {
        this.notificationProducer = notificationProducer;
        this.eventAppService = eventAppService;
        this.serviceConfiguration = serviceConfiguration;
        this.chainMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTextMessage(WebSocketSession session, TextMessage message) throws IOException {
        if (!session.isOpen()) {
            this.removeOldSection(session);
            return;
        }
        WebSocketSession webSocketSession = session;
        synchronized (webSocketSession) {
            session.sendMessage((WebSocketMessage)message);
        }
    }

    public void publishTopicOffset(SomaWebSocketSession somaWebSocketSession, JsonObject event) {
        if (somaWebSocketSession.getWebSocketSession().isOpen()) {
            for (WebsocketNotifierInfo wsInfo : somaWebSocketSession.getWebsocketNotifierInfoList()) {
                if (!wsInfo.getTopicName().equals(event.get("topic_name").getAsString())) continue;
                if (event.get("offset").getAsInt() > wsInfo.getOffset()) {
                    wsInfo.setOffset(Integer.valueOf(event.get("offset").getAsInt()));
                }
                this.notificationProducer.publishKafkaOffset(wsInfo, WebsocketNotifierStatus.valueOf((String)event.get("eventStatus").getAsString()));
            }
        }
    }

    private AbstractChain getChain(JsonObject eventMessage) {
        String factoryClassName = eventMessage.get("eventName").getAsString();
        AbstractChain chain = (AbstractChain)this.chainMap.get(factoryClassName = factoryClassName.substring(0, 1).toUpperCase() + factoryClassName.substring(1));
        if (chain == null) {
            try {
                Class<?> factoryClazz = Class.forName("br.pucrio.tecgraf.soma.websocketnotifier.factory." + factoryClassName);
                Method method = factoryClazz.getDeclaredMethod("createChain", new Class[0]);
                Object factoryInstance = factoryClazz.newInstance();
                chain = (AbstractChain)method.invoke(factoryInstance, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                chain = new EmptyChain();
            }
            catch (Throwable e) {
                this.logger.error("Error call method 'createChain' of factory " + factoryClassName, e);
                return null;
            }
            this.chainMap.put(factoryClassName, chain);
        }
        return chain;
    }

    private JsonObject createCleanEvent(JsonObject event) {
        JsonObject cleanEvent = event.deepCopy();
        cleanEvent.remove("topic_name");
        cleanEvent.remove("offset");
        return cleanEvent;
    }

    public void sendMessage(JsonObject event) throws IOException {
        this.sendMessageSpecificSession(event, null);
    }

    private void sendMessageSpecificSession(JsonObject event, SomaWebSocketSession targetSession) throws IOException {
        try {
            HandlerResult result;
            AbstractChain chain = this.getChain(event);
            if (chain != null && (result = chain.handlerRequest(event, this.sessions)).getSessions() != null && result.getSessions().size() > 0) {
                JsonObject cleanEvent = this.createCleanEvent(result.getEvent());
                for (SomaWebSocketSession somaWebSocketSession : result.getSessions()) {
                    boolean send = false;
                    if (targetSession == null) {
                        send = true;
                    } else if (targetSession.getWebSocketSession().getId().equals(somaWebSocketSession.getWebSocketSession().getId())) {
                        send = true;
                    }
                    if (!send) continue;
                    this.handleTextMessage(somaWebSocketSession.getWebSocketSession(), new TextMessage((CharSequence)cleanEvent.toString()));
                    this.publishTopicOffset(somaWebSocketSession, result.getEvent());
                }
            }
        }
        catch (ChainException chainException) {
            // empty catch block
        }
    }

    private String getParamFromQuery(String query, String paramName) {
        List<String> params = Arrays.asList(query.split("&"));
        for (String param : params) {
            List<String> paramProp = Arrays.asList(param.split("="));
            if (paramProp.size() <= 1 || !paramName.equals(paramProp.get(0))) continue;
            return paramProp.get(1);
        }
        return null;
    }

    private String getUserFromToken(String token) {
        String base64Url = token.split("\\.")[1];
        String userToken = new String(Base64.getDecoder().decode(base64Url));
        JsonObject user = new JsonParser().parse(userToken).getAsJsonObject();
        return user.get("sub").getAsString();
    }

    protected void removeOldSection(WebSocketSession oldSection) {
        for (SomaWebSocketSession somaSection : this.sessions) {
            if (!somaSection.getWebSocketSession().getId().equals(oldSection.getId())) continue;
            this.sessions.remove(somaSection);
        }
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        URI sessionUri = session.getUri();
        String accessToken = this.getParamFromQuery(sessionUri.getQuery(), "token");
        String application = this.getParamFromQuery(sessionUri.getQuery(), "application");
        String user = this.getUserFromToken(accessToken);
        List<String> topics = Arrays.asList(this.serviceConfiguration.getValue(Constants.Config.KAFKA_TOPIC.option.getLongName()).split(";"));
        if (accessToken == null || accessToken.isEmpty()) {
            throw new AuthenticationCredentialsNotFoundException("Authorization token is required");
        }
        List projects = this.eventAppService.getUserProjects(accessToken);
        if (projects.isEmpty()) {
            throw new NotFoundException("User has access to no projects");
        }
        SomaWebSocketSession somaSession = new SomaWebSocketSession(session);
        somaSession.setProjectIds(projects);
        this.sessions.add(somaSession);
        if (user != null && application != null && !user.isEmpty() && !application.isEmpty()) {
            List wsInfos = this.notificationProducer.buildWebsocketInfos(user, application, topics);
            somaSession.setWebsocketNotifierInfoList(wsInfos);
            this.logger.info("New user connected {}", (Object)wsInfos);
            List lostMessagesOfUser = this.notificationProducer.getLostMessagesToUser(wsInfos);
            for (JsonObject lostMessage : lostMessagesOfUser) {
                this.sendMessageSpecificSession(lostMessage, somaSession);
            }
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        this.removeOldSection(session);
    }
}

