package br.pucrio.tecgraf.soma.websocketnotifier.factory.chain;

import java.util.List;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;
import org.apache.avro.data.Json;

public class JobEventChain extends AbstractChain {

	@Override
	public HandlerResult handlerRequest(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException {
		JsonObject jsonEvent = event.getAsJsonObject("event");
		String eventName = event.get("eventName").getAsString();

		jsonEvent.addProperty("type", this.getJobType(eventName));
		jsonEvent.addProperty("state", this.getJobState(eventName));

		event.addProperty("eventName", "JobHistoryEvent");

		if( jsonEvent.has("specificationType")) {
			if(jsonEvent.get("specificationType").getAsString().toLowerCase().equals("flow")) {
				if (jsonEvent.has("specification")) {
					JsonObject specificationJson = jsonEvent.getAsJsonObject("specification");

					if (specificationJson.has("raw")) {
						specificationJson.remove("raw");
					}

					if (specificationJson.has("algorithms")) {
						JsonArray algorithmArray = specificationJson.get("algorithms").getAsJsonArray();
						specificationJson.remove("algorithms");

						for (JsonElement algorithm : algorithmArray) {
							JsonObject algorithmObject = algorithm.getAsJsonObject();
							if (algorithmObject.has("parameters")) {
								algorithmObject.remove("parameters");
							}
						}
						jsonEvent.add("algorithms", algorithmArray);
					}
				}
			} else {
				// Transformando a propriedade algorithm em um array, assim como o flow para
				// facilitar o tratamento no frontend
				if (jsonEvent.has("specification")) {
					JsonObject specificationJson = jsonEvent.getAsJsonObject("specification");
					if (specificationJson.has("parameters")) {
						specificationJson.remove("parameters");
					}
					jsonEvent.remove("specification");
					JsonArray algorithmArray = new JsonArray();
					algorithmArray.add(specificationJson);
					jsonEvent.add("algorithms", algorithmArray);
					}
			}
		}


		return next(event, sessions);
	}
	private String getJobState(String eventName) {
		switch (eventName){
			case "JobScheduledEvent":
				return "SCHEDULED";
			case "JobStageInEvent":
				return "UPLOADING";
			case "JobExecutingEvent":
				return "EXECUTING";
			case "JobStageOutEvent":
				return "DOWNLOADING";
			case "JobFinishedEvent":
				return "FINISHED";
		}
		return null;
	}

	private String getJobType(String eventName){
		switch (eventName){
			case "JobScheduledEvent":
				return "CREATE";
			case "JobStageInEvent":
			case "JobExecutingEvent":
			case "JobStageOutEvent":
			case "JobFinishedEvent":
				return "UPDATE";
		}
		return null;
	}

}
