package br.pucrio.tecgraf.soma.websocketnotifier.factory.chain;

import java.util.ArrayList;
import java.util.List;

import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;

import com.google.gson.JsonObject;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;

public class ProjectPermissionFilter extends AbstractChain {

	private boolean requiredProject;

	/**
	 * Construtor
	 * 
	 * @param requiredProject True se o projeto for obrigatorio. False caso
	 *                        negativo. Se nao for obrigatorio e nao tenha projeto,
	 *                        ele envia para todo mundo mensagem. Se tiver projeto,
	 *                        independente do valor, ele sempre valida a permissao
	 */
	public ProjectPermissionFilter(boolean requiredProject) {
		this.requiredProject = requiredProject;
	}

	@Override
	public HandlerResult handlerRequest(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException {
		
		List<SomaWebSocketSession> autorizedSessions = new ArrayList<SomaWebSocketSession>();
		
		if (event.get("event").getAsJsonObject().has("projectId")) {
			String sessionProjectId = event.get("event").getAsJsonObject().get("projectId").getAsString();
			for (SomaWebSocketSession somaWebSocketSession : sessions) {
				if (somaWebSocketSession.getProjectIds() != null && !somaWebSocketSession.getProjectIds().isEmpty()) {
					for (String projectId : somaWebSocketSession.getProjectIds()) {
						if (sessionProjectId.equals(projectId) ) {
							autorizedSessions.add(somaWebSocketSession);
						}
					}
				}
			}
		}
		else {
			if( !this.requiredProject) {
				//nao tem projectId, logo todo mundo é permitido
				autorizedSessions = sessions;
			}			
		}
		
		return next(event, autorizedSessions);
	}

}
