/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.factory.chain;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.SomaWebSocketSession;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.AbstractChain;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.ChainException;
import br.pucrio.tecgraf.soma.websocketnotifier.factory.chain.HandlerResult;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;

public class JobEventChain
extends AbstractChain {
    public HandlerResult handlerRequest(JsonObject event, List<SomaWebSocketSession> sessions) throws ChainException {
        JsonObject jsonEvent = event.getAsJsonObject("event");
        String eventName = event.get("eventName").getAsString();
        jsonEvent.addProperty("type", this.getJobType(eventName));
        jsonEvent.addProperty("state", this.getJobState(eventName));
        event.addProperty("eventName", "JobHistoryEvent");
        if (jsonEvent.has("specificationType")) {
            if (jsonEvent.get("specificationType").getAsString().toLowerCase().equals("flow")) {
                if (jsonEvent.has("specification")) {
                    JsonObject specificationJson = jsonEvent.getAsJsonObject("specification");
                    if (specificationJson.has("raw")) {
                        specificationJson.remove("raw");
                    }
                    if (specificationJson.has("algorithms")) {
                        JsonArray algorithmArray = specificationJson.get("algorithms").getAsJsonArray();
                        specificationJson.remove("algorithms");
                        for (JsonElement algorithm : algorithmArray) {
                            JsonObject algorithmObject = algorithm.getAsJsonObject();
                            if (!algorithmObject.has("parameters")) continue;
                            algorithmObject.remove("parameters");
                        }
                        jsonEvent.add("algorithms", (JsonElement)algorithmArray);
                    }
                }
            } else if (jsonEvent.has("specification")) {
                JsonObject specificationJson = jsonEvent.getAsJsonObject("specification");
                if (specificationJson.has("parameters")) {
                    specificationJson.remove("parameters");
                }
                jsonEvent.remove("specification");
                JsonArray algorithmArray = new JsonArray();
                algorithmArray.add((JsonElement)specificationJson);
                jsonEvent.add("algorithms", (JsonElement)algorithmArray);
            }
        }
        return this.next(event, sessions);
    }

    private String getJobState(String eventName) {
        switch (eventName) {
            case "JobScheduledEvent": {
                return "SCHEDULED";
            }
            case "JobInitEvent": {
                return "INIT";
            }
            case "JobStageInEvent": {
                return "UPLOADING";
            }
            case "JobExecutingEvent": {
                return "EXECUTING";
            }
            case "JobStageOutEvent": {
                return "DOWNLOADING";
            }
            case "JobFinishedEvent": {
                return "FINISHED";
            }
        }
        return null;
    }

    private String getJobType(String eventName) {
        switch (eventName) {
            case "JobScheduledEvent": {
                return "CREATE";
            }
            case "JobInitEvent": 
            case "JobStageInEvent": 
            case "JobExecutingEvent": 
            case "JobStageOutEvent": 
            case "JobFinishedEvent": {
                return "UPDATE";
            }
        }
        return null;
    }
}

