/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.metadata.ExcelColumnProperty;
import com.alibaba.excel.metadata.ExcelHeadProperty;
import com.alibaba.excel.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.cglib.beans.BeanMap;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public class TypeUtil {
    private static List<String> DATE_FORMAT_LIST = new ArrayList<String>(4);
    public static final Pattern pattern;

    private static int getCountOfChar(String value, char c) {
        char[] chars;
        int n = 0;
        if (value == null) {
            return 0;
        }
        for (char cc : chars = value.toCharArray()) {
            if (cc != c) continue;
            ++n;
        }
        return n;
    }

    public static Object convert(String value, Field field, String format, boolean us) {
        if (!StringUtils.isEmpty(value)) {
            if (Float.class.equals(field.getType())) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (Integer.class.equals(field.getType()) || Integer.TYPE.equals(field.getType())) {
                return Integer.parseInt(value);
            }
            if (Double.class.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
                if (null != format && !"".equals(format)) {
                    int n = TypeUtil.getCountOfChar(value, '0');
                    return Double.parseDouble(TypeUtil.formatFloat0(value, n));
                }
                return Double.parseDouble(TypeUtil.formatFloat(value));
            }
            if (Boolean.class.equals(field.getType()) || Boolean.TYPE.equals(field.getType())) {
                String valueLower = value.toLowerCase();
                if (valueLower.equals("true") || valueLower.equals("false")) {
                    return Boolean.parseBoolean(value.toLowerCase());
                }
                Integer integer = Integer.parseInt(value);
                if (integer == 0) {
                    return false;
                }
                return true;
            }
            if (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) {
                return Long.parseLong(value);
            }
            if (Date.class.equals(field.getType())) {
                if (value.contains("-") || value.contains("/") || value.contains(":")) {
                    return TypeUtil.getSimpleDateFormatDate(value, format);
                }
                Double d = Double.parseDouble(value);
                return HSSFDateUtil.getJavaDate((double)d, (boolean)us);
            }
            if (BigDecimal.class.equals(field.getType())) {
                return new BigDecimal(value);
            }
            if (String.class.equals(field.getType())) {
                return TypeUtil.formatFloat(value);
            }
        }
        return null;
    }

    public static Boolean isNum(Field field) {
        if (field == null) {
            return false;
        }
        if (Integer.class.equals(field.getType()) || Integer.TYPE.equals(field.getType())) {
            return true;
        }
        if (Double.class.equals(field.getType()) || Double.TYPE.equals(field.getType())) {
            return true;
        }
        if (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) {
            return true;
        }
        if (BigDecimal.class.equals(field.getType())) {
            return true;
        }
        return false;
    }

    public static Boolean isNum(Object cellValue) {
        if (cellValue instanceof Integer || cellValue instanceof Double || cellValue instanceof Short || cellValue instanceof Long || cellValue instanceof Float || cellValue instanceof BigDecimal) {
            return true;
        }
        return false;
    }

    public static String getDefaultDateString(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static Date getSimpleDateFormatDate(String value, String format) {
        if (!StringUtils.isEmpty(value)) {
            Date date = null;
            if (!StringUtils.isEmpty(format)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
                try {
                    date = simpleDateFormat.parse(value);
                    return date;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            for (String dateFormat : DATE_FORMAT_LIST) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                    date = simpleDateFormat.parse(value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (date == null) continue;
                break;
            }
            return date;
        }
        return null;
    }

    public static String formatFloat(String value) {
        if (null != value && value.contains(".") && TypeUtil.isNumeric(value)) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                BigDecimal setScale = decimal.setScale(10, 5).stripTrailingZeros();
                return setScale.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static String formatFloat0(String value, int n) {
        if (null != value && value.contains(".") && TypeUtil.isNumeric(value)) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                BigDecimal setScale = decimal.setScale(n, 5);
                return setScale.toPlainString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    private static boolean isNumeric(String str) {
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String formatDate(Date cellValue, String format) {
        SimpleDateFormat simpleDateFormat = !StringUtils.isEmpty(format) ? new SimpleDateFormat(format) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(cellValue);
    }

    public static String getFieldStringValue(BeanMap beanMap, String fieldName, String format) {
        String cellValue = null;
        Object value = beanMap.get((Object)fieldName);
        if (value != null) {
            cellValue = value instanceof Date ? TypeUtil.formatDate((Date)value, format) : value.toString();
        }
        return cellValue;
    }

    public static Map getFieldValues(List<String> stringList, ExcelHeadProperty excelHeadProperty, Boolean use1904WindowDate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < stringList.size(); ++i) {
            Object value;
            ExcelColumnProperty columnProperty = excelHeadProperty.getExcelColumnProperty(i);
            if (columnProperty == null || (value = TypeUtil.convert(stringList.get(i), columnProperty.getField(), columnProperty.getFormat(), use1904WindowDate)) == null) continue;
            map.put(columnProperty.getField().getName(), value);
        }
        return map;
    }

    static {
        DATE_FORMAT_LIST.add("yyyy/MM/dd HH:mm:ss");
        DATE_FORMAT_LIST.add("yyyy-MM-dd HH:mm:ss");
        DATE_FORMAT_LIST.add("yyyyMMdd HH:mm:ss");
        pattern = Pattern.compile("[\\+\\-]?[\\d]+([\\.][\\d]*)?([Ee][+-]?[\\d]+)?$");
    }
}

