/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format.formatter;

import com.cosium.code.format.formatter.CodeFormatter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class CompositeCodeFormatter
implements CodeFormatter {
    private final Collection<CodeFormatter> formatters;

    public CompositeCodeFormatter(CodeFormatter ... formatters) {
        this.formatters = Collections.unmodifiableCollection(Arrays.asList(formatters));
    }

    @Override
    public void format(Path file) {
        this.formatters.forEach(formatter -> formatter.format(file));
    }

    @Override
    public boolean validate(Path file) {
        return this.formatters.stream().map(codeFormatter -> codeFormatter.validate(file)).filter(valid -> valid == false).findFirst().orElse(true);
    }
}

