/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dataConvertion.accessor;

import dm.jdbc.dataConvertion.accessor.BinaryAccessor;
import dm.jdbc.dataConvertion.accessor.BlobAccessor;
import dm.jdbc.dataConvertion.accessor.ByteAccessor;
import dm.jdbc.dataConvertion.accessor.ClobAccessor;
import dm.jdbc.dataConvertion.accessor.ComplexTypeAccessor;
import dm.jdbc.dataConvertion.accessor.DatetimeAccessor;
import dm.jdbc.dataConvertion.accessor.DecimalAccessor;
import dm.jdbc.dataConvertion.accessor.DoubleAccessor;
import dm.jdbc.dataConvertion.accessor.IntAccessor;
import dm.jdbc.dataConvertion.accessor.IntervalDTAccessor;
import dm.jdbc.dataConvertion.accessor.IntervalYMAccessor;
import dm.jdbc.dataConvertion.accessor.LongAccessor;
import dm.jdbc.dataConvertion.accessor.RealAccessor;
import dm.jdbc.dataConvertion.accessor.ShortAccessor;
import dm.jdbc.dataConvertion.accessor.StringAccessor;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.ColumnDesc;
import dm.jdbc.desc.CommDesc;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbResultSetCache;
import dm.jdbc.driver.DmdbResultSetCache_v;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTimestamp;
import dm.sql.TypeDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAccessor {
    public byte[] dataBuffer;
    short colIndex;
    short colCount;
    DmdbResultSetCache rsCache;
    boolean isRs = true;
    int localTimezone;
    int dbTimezone;
    boolean wasNull;
    int fixedLength = 0;
    String serverEncoding;
    int dtype;
    int scale;
    int prec;
    String dTypeName;
    boolean compatibleOracle;
    String registTypeName;
    TypeDescriptor registTypeDescriptor;
    int registSqlType;

    public static BaseAccessor getInstance(DmdbResultSetCache rsCache, CommDesc desc, DmdbConnection_bs conn, int colIndex, int colCount, int maxFieldSize) throws SQLException {
        BaseAccessor accessor = null;
        boolean isBdta = false;
        if (rsCache instanceof DmdbResultSetCache_v) {
            isBdta = true;
        }
        switch (desc.getDType()) {
            case 3: 
            case 5: 
            case 13: {
                accessor = new ByteAccessor();
                accessor.fixedLength = 1;
                break;
            }
            case 6: {
                accessor = new ShortAccessor();
                accessor.fixedLength = 2;
                break;
            }
            case 7: {
                accessor = new IntAccessor();
                accessor.fixedLength = 4;
                break;
            }
            case 8: {
                accessor = new LongAccessor();
                accessor.fixedLength = 8;
                break;
            }
            case 10: {
                accessor = new RealAccessor();
                accessor.fixedLength = 4;
                break;
            }
            case 11: {
                accessor = new DoubleAccessor();
                accessor.fixedLength = 8;
                break;
            }
            case 9: {
                accessor = new DecimalAccessor();
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                accessor = new StringAccessor();
                break;
            }
            case 19: {
                accessor = new ClobAccessor(conn, desc.getLobDesc(), desc instanceof ColumnDesc ? ((ColumnDesc)desc).isReadOnly() : true);
                break;
            }
            case 14: {
                accessor = new DatetimeAccessor(isBdta);
                accessor.fixedLength = 3;
                break;
            }
            case 15: {
                accessor = new DatetimeAccessor(isBdta);
                accessor.fixedLength = 5;
                break;
            }
            case 22: {
                accessor = new DatetimeAccessor(isBdta);
                accessor.fixedLength = 7;
                break;
            }
            case 16: {
                accessor = new DatetimeAccessor(isBdta);
                accessor.fixedLength = 8;
                break;
            }
            case 23: {
                accessor = new DatetimeAccessor(isBdta);
                accessor.fixedLength = 10;
                break;
            }
            case 17: 
            case 18: {
                accessor = new BinaryAccessor(maxFieldSize);
                break;
            }
            case 12: {
                accessor = new BlobAccessor(conn, desc.getLobDesc(), desc instanceof ColumnDesc ? ((ColumnDesc)desc).isReadOnly() : true, desc.getTypeDescriptor(), maxFieldSize);
                break;
            }
            case 21: {
                accessor = new IntervalDTAccessor();
                break;
            }
            case 20: {
                accessor = new IntervalYMAccessor();
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                accessor = new ComplexTypeAccessor(desc.getTypeDescriptor());
                break;
            }
            default: {
                accessor = new BaseAccessor();
            }
        }
        accessor.setDtype(desc.getDType());
        accessor.prec = desc.getPrec();
        accessor.scale = desc.getScale();
        accessor.dTypeName = desc.getTypeName();
        accessor.rsCache = rsCache;
        accessor.serverEncoding = conn.getServerEncoding();
        accessor.localTimezone = conn.getClientTz();
        accessor.dbTimezone = conn.getDbTz();
        accessor.compatibleOracle = conn.isCompatibleOracle();
        accessor.colIndex = (short)colIndex;
        accessor.colCount = (short)colCount;
        boolean bl = accessor.isRs = rsCache != null;
        if (accessor.fixedLength > 0) {
            accessor.dataBuffer = new byte[accessor.fixedLength];
        }
        return accessor;
    }

    public static BaseAccessor getInstance(CommDesc dtypeInfo, DmdbConnection_bs conn, int maxFieldSize) throws SQLException {
        return BaseAccessor.getInstance(null, dtypeInfo, conn, 0, 0, maxFieldSize);
    }

    public boolean getBoolean() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return false;
    }

    public byte getByte() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0;
    }

    public short getShort() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0;
    }

    public int getInt() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0;
    }

    public long getLong() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0L;
    }

    public float getFloat() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0.0f;
    }

    public double getDouble() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return 0.0;
    }

    public BigDecimal getBigDecimal() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Date getDate() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Time getTime() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Timestamp getTimestamp() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public DmdbTimestamp getDmdbTimestamp() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public String getString() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Clob getClob() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Blob getBlob() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Struct getStruct() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public Array getArray() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public DmdbIntervalYM getIntervalYM() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public DmdbIntervalDT getIntervalDT() throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public final Object getObject(Map<String, Class<?>> typeMap) throws SQLException {
        if (this.registSqlType != 0) {
            switch (this.registSqlType) {
                case -7: 
                case 16: {
                    return this.getBoolean();
                }
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt();
                }
                case -5: {
                    return this.getLong();
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal();
                }
                case 6: 
                case 7: {
                    return Float.valueOf(this.getFloat());
                }
                case 8: {
                    return this.getDouble();
                }
                case -1: 
                case 1: 
                case 12: {
                    return this.getString();
                }
                case 91: {
                    return this.getDate();
                }
                case 92: {
                    return this.getTime();
                }
                case 93: {
                    return this.getTimestamp();
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getBytes();
                }
                case 2004: {
                    return this.getBlob();
                }
                case 2005: {
                    return this.getClob();
                }
                case 2003: {
                    return this.getArray();
                }
                case 2002: {
                    if (this instanceof ComplexTypeAccessor) {
                        return this.getObjectInner(typeMap);
                    }
                    return this.getStruct();
                }
            }
            return this.getObjectInner(typeMap);
        }
        return this.getObjectInner(typeMap);
    }

    Object getObjectInner(Map<String, Class<?>> typeMap) throws SQLException {
        this.getByteArrayValue();
        if (!this.wasNull) {
            DBError.throwSQLException(6007);
        }
        return null;
    }

    public byte[] getBytes() throws SQLException {
        if (this.isRs) {
            byte[] retBytes = this.rsCache.getBytes(this.colIndex);
            this.wasNull = retBytes == null;
            return retBytes;
        }
        return this.dataBuffer;
    }

    protected void getByteArrayValue() throws SQLException {
        if (this.isRs) {
            if (this.fixedLength > 0) {
                this.wasNull = this.rsCache.getBytesFillBuffer(this.colIndex, this.dataBuffer);
            } else {
                this.dataBuffer = this.rsCache.getBytes(this.colIndex);
                this.wasNull = this.dataBuffer == null;
            }
        }
    }

    public void setOutValue(byte[] value) {
        this.dataBuffer = value;
        this.wasNull = value == null;
    }

    public boolean isWasNull() {
        return this.wasNull;
    }

    public void setWasNull(boolean wasNull) {
        this.wasNull = wasNull;
    }

    public void setRegistTypeName(String typeName) {
        this.registTypeName = typeName;
    }

    public void setRegistTypeDescriptor(TypeDescriptor typeDesc) {
        this.registTypeDescriptor = typeDesc;
    }

    public void setRegistSqlType(int sqlType) {
        this.registSqlType = sqlType;
    }

    public void setDtype(int dtype) {
        this.dtype = dtype;
    }

    public int getDtype() {
        return this.dtype;
    }
}

