/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu.serialization.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.ws.rs.FormParam;
import si.mazi.rescu.RequestWriter;
import si.mazi.rescu.RestInvocation;

public class JacksonRequestWriter
implements RequestWriter {
    private final ObjectMapper objectMapper;

    public JacksonRequestWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String writeBody(RestInvocation invocation) {
        if (!"application/json".equals(invocation.getMethodMetadata().getReqContentType())) {
            throw new IllegalArgumentException("JsonRequestWriter supports application/json content type only!");
        }
        if (invocation.getParamsMap().get(FormParam.class) != null && !invocation.getParamsMap().get(FormParam.class).isEmpty()) {
            throw new IllegalArgumentException("@FormParams are not allowed with application/json");
        }
        if (invocation.getUnannanotatedParams().size() > 1) {
            throw new IllegalArgumentException("Can only have a single unannotated parameter with application/json");
        }
        if (invocation.getUnannanotatedParams().isEmpty()) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(invocation.getUnannanotatedParams().get(0));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error writing json. This could be due to an error in your Jackson mapping, or a bug in rescu.", e);
        }
    }
}

