/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api;

import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;

/**
 * ShortIterable is an interface which is memory-optimized for short primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an ShortIterator. ShortIterator helps iterate over the ShortIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface ShortIterable extends PrimitiveIterable
{
    ShortIterator shortIterator();

    short[] toArray();

    boolean contains(short value);

    boolean containsAll(short... source);

    boolean containsAll(ShortIterable source);

    void forEach(ShortProcedure procedure);

    ShortIterable select(ShortPredicate predicate);

    ShortIterable reject(ShortPredicate predicate);

    <V> RichIterable<V> collect(ShortToObjectFunction<? extends V> function);

    short detectIfNone(ShortPredicate predicate, short ifNone);

    int count(ShortPredicate predicate);

    boolean anySatisfy(ShortPredicate predicate);

    boolean allSatisfy(ShortPredicate predicate);

    boolean noneSatisfy(ShortPredicate predicate);

    MutableShortList toList();

    MutableShortSet toSet();

    MutableShortBag toBag();

    LazyShortIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function);


    long sum();

    short max();

    short maxIfEmpty(short defaultValue);

    short min();

    short minIfEmpty(short defaultValue);

    double average();

    double median();

    short[] toSortedArray();

    MutableShortList toSortedList();
}
