/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for Procedure API.
 * <p>
 *     A Procedure is a single argument lambda which has no return argument.
 * <p>
 *     This package contains the following interfaces:
 *     <ul>
 *         <li>
 *              {@link com.gs.collections.api.block.procedure.Procedure} - a single argument lambda which has no return argument.
 *         </li>
 *         <li>
 *              {@link com.gs.collections.api.block.procedure.Procedure2} - a two argument Procedure. Used by forEachWith() methods and for MapIterate.forEachKeyValue().
 *         </li>
 *     </ul>
 */
package com.gs.collections.api.block.procedure;
